/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.Tuple;

@JsonPropertyOrder(value={"tuples", "continuation_token"})
public class ReadResponse {
    public static final String JSON_PROPERTY_TUPLES = "tuples";
    @Nonnull
    private List<Tuple> tuples = new ArrayList<Tuple>();
    public static final String JSON_PROPERTY_CONTINUATION_TOKEN = "continuation_token";
    @Nonnull
    private String continuationToken;

    public ReadResponse tuples(@Nonnull List<Tuple> tuples) {
        this.tuples = tuples;
        return this;
    }

    public ReadResponse addTuplesItem(Tuple tuplesItem) {
        if (this.tuples == null) {
            this.tuples = new ArrayList<Tuple>();
        }
        this.tuples.add(tuplesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="tuples")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Tuple> getTuples() {
        return this.tuples;
    }

    @JsonProperty(value="tuples")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTuples(@Nonnull List<Tuple> tuples) {
        this.tuples = tuples;
    }

    public ReadResponse continuationToken(@Nonnull String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @Nonnull
    @JsonProperty(value="continuation_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContinuationToken() {
        return this.continuationToken;
    }

    @JsonProperty(value="continuation_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContinuationToken(@Nonnull String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadResponse readResponse = (ReadResponse)o;
        return Objects.equals(this.tuples, readResponse.tuples) && Objects.equals(this.continuationToken, readResponse.continuationToken);
    }

    public int hashCode() {
        return Objects.hash(this.tuples, this.continuationToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadResponse {\n");
        sb.append("    tuples: ").append(this.toIndentedString(this.tuples)).append("\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTuples() != null) {
            for (int i = 0; i < this.getTuples().size(); ++i) {
                if (this.getTuples().get(i) == null) continue;
                joiner.add(this.getTuples().get(i).toUrlQueryString(String.format("%stuples%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getContinuationToken() != null) {
            joiner.add(String.format("%scontinuation_token%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getContinuationToken()))));
        }
        return joiner.toString();
    }
}

