/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.oidc.OIDCLoginResponse;
import org.apache.syncope.common.lib.oidc.OIDCRequest;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.oidc.NoOpSessionStore;
import org.apache.syncope.core.logic.oidc.OIDCC4UIContext;
import org.apache.syncope.core.logic.oidc.OIDCClientCache;
import org.apache.syncope.core.logic.oidc.OIDCUserManager;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCC4UIProviderDAO;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIProvider;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.SessionKeyCredentials;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.redirect.OidcRedirectionActionBuilder;
import org.springframework.security.access.prepost.PreAuthorize;

public class OIDCC4UILogic
extends AbstractTransactionalLogic<EntityTO> {
    protected static final String JWT_CLAIM_OP_NAME = "OP_NAME";
    protected static final String JWT_CLAIM_ID_TOKEN = "ID_TOKEN";
    protected final OIDCClientCache oidcClientCacheLogin;
    protected final OIDCClientCache oidcClientCacheLogout;
    protected final AuthDataAccessor authDataAccessor;
    protected final AccessTokenDataBinder accessTokenDataBinder;
    protected final OIDCC4UIProviderDAO opDAO;
    protected final AccessTokenDAO accessTokenDAO;
    protected final OIDCUserManager userManager;
    protected final EncryptorManager encryptorManager;

    public OIDCC4UILogic(OIDCClientCache oidcClientCacheLogin, OIDCClientCache oidcClientCacheLogout, AuthDataAccessor authDataAccessor, AccessTokenDataBinder accessTokenDataBinder, OIDCC4UIProviderDAO opDAO, AccessTokenDAO accessTokenDAO, OIDCUserManager userManager, EncryptorManager encryptorManager) {
        this.oidcClientCacheLogin = oidcClientCacheLogin;
        this.oidcClientCacheLogout = oidcClientCacheLogout;
        this.authDataAccessor = authDataAccessor;
        this.accessTokenDataBinder = accessTokenDataBinder;
        this.opDAO = opDAO;
        this.accessTokenDAO = accessTokenDAO;
        this.userManager = userManager;
        this.encryptorManager = encryptorManager;
    }

    protected OidcClient getOidcClient(OIDCClientCache oidcClientCache, OIDCC4UIProvider op, String callbackUrl) {
        return oidcClientCache.get(op.getName()).map(oidcClient -> {
            Optional.ofNullable(callbackUrl).filter(c -> !c.equals(oidcClient.getCallbackUrl())).ifPresent(arg_0 -> ((OidcClient)oidcClient).setCallbackUrl(arg_0));
            return oidcClient;
        }).orElseGet(() -> oidcClientCache.add(op, callbackUrl));
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public OIDCRequest createLoginRequest(String redirectURI, String opName, final boolean reauth) {
        OIDCC4UIProvider op = (OIDCC4UIProvider)this.opDAO.findByName(opName).orElseThrow(() -> new NotFoundException("OIDC Provider '" + opName + "'"));
        OidcClient oidcClient = this.getOidcClient(this.oidcClientCacheLogin, op, redirectURI);
        oidcClient.setRedirectionActionBuilder((RedirectionActionBuilder)new OidcRedirectionActionBuilder(this, oidcClient){

            protected Map<String, String> buildParams(WebContext webContext) {
                Map params = super.buildParams(webContext);
                if (reauth) {
                    params.put("prompt", "login");
                    params.put("max_age", "0");
                }
                return params;
            }
        });
        WithLocationAction action = oidcClient.getRedirectionAction(new CallContext((WebContext)new OIDCC4UIContext(), (SessionStore)NoOpSessionStore.INSTANCE)).map(WithLocationAction.class::cast).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add("No RedirectionAction generated for LoginRequest");
            return sce;
        });
        OIDCRequest loginRequest = new OIDCRequest();
        loginRequest.setLocation(action.getLocation());
        return loginRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public OIDCLoginResponse login(String redirectURI, String authorizationCode, String opName) {
        String username;
        OIDCLoginResponse loginResp;
        String idTokenHint;
        JWTClaimsSet idToken;
        block14: {
            OIDCC4UIProvider op = (OIDCC4UIProvider)this.opDAO.findByName(opName).orElseThrow(() -> new NotFoundException("OIDC Provider '" + opName + "'"));
            OidcClient oidcClient = this.getOidcClient(this.oidcClientCacheLogin, op, redirectURI);
            try {
                OidcCredentials credentials = new OidcCredentials();
                credentials.setCode(authorizationCode);
                oidcClient.getAuthenticator().validate(new CallContext((WebContext)new OIDCC4UIContext(), (SessionStore)NoOpSessionStore.INSTANCE), (Credentials)credentials);
                JWT jwt = credentials.toIdToken();
                idToken = jwt.getJWTClaimsSet();
                idTokenHint = jwt.serialize();
            }
            catch (Exception e) {
                LOG.error("While validating Token Response", (Throwable)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
            loginResp = new OIDCLoginResponse();
            loginResp.setLogoutSupported(StringUtils.isNotBlank((CharSequence)op.getEndSessionEndpoint()));
            String keyValue = idToken.getSubject();
            for (Item item : op.getItems()) {
                Attr attrTO = new Attr();
                attrTO.setSchema(item.getExtAttrName());
                String value2 = Optional.ofNullable(idToken.getClaim(item.getExtAttrName())).map(Object::toString).orElse(null);
                if (value2 == null) continue;
                attrTO.getValues().add(value2);
                loginResp.getAttrs().add(attrTO);
                if (!item.isConnObjectKey()) continue;
                keyValue = value2;
            }
            List matchingUsers = Optional.ofNullable(keyValue).map(k -> this.userManager.findMatchingUser((String)k, (Item)op.getConnObjectKeyItem().get())).orElseGet(List::of);
            LOG.debug("Found {} matching users for {}", (Object)matchingUsers.size(), (Object)keyValue);
            if (matchingUsers.isEmpty()) {
                if (op.isCreateUnmatching()) {
                    LOG.debug("No user matching {}, about to create", (Object)keyValue);
                    String defaultUsername = keyValue;
                    username = (String)AuthContextUtils.callAsAdmin((String)AuthContextUtils.getDomain(), () -> this.userManager.create(op, loginResp, defaultUsername));
                    break block14;
                } else {
                    if (!op.isSelfRegUnmatching()) {
                        throw new NotFoundException(Optional.ofNullable(keyValue).map(value -> "User matching the provided value " + value).orElse("User marching the provided claims"));
                    }
                    UserTO userTO = new UserTO();
                    this.userManager.fill(op, loginResp, userTO);
                    loginResp.getAttrs().clear();
                    loginResp.getAttrs().addAll(userTO.getPlainAttrs());
                    if (StringUtils.isNotBlank((CharSequence)userTO.getUsername())) {
                        loginResp.setUsername(userTO.getUsername());
                    } else {
                        loginResp.setUsername(keyValue);
                    }
                    loginResp.setSelfReg(true);
                    return loginResp;
                }
            }
            if (matchingUsers.size() > 1) {
                throw new IllegalArgumentException("Several users match the provided value " + keyValue);
            }
            if (op.isUpdateMatching()) {
                LOG.debug("About to update {} for {}", matchingUsers.getFirst(), (Object)keyValue);
                username = (String)AuthContextUtils.callAsAdmin((String)AuthContextUtils.getDomain(), () -> this.userManager.update((String)matchingUsers.getFirst(), op, loginResp));
            } else {
                username = (String)matchingUsers.getFirst();
            }
        }
        loginResp.setUsername(username);
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put(JWT_CLAIM_OP_NAME, opName);
        claims.put(JWT_CLAIM_ID_TOKEN, idTokenHint);
        String authorities = null;
        try {
            authorities = this.encryptorManager.getInstance().encode(POJOHelper.serialize((Object)this.authDataAccessor.getAuthorities(loginResp.getUsername(), null)), CipherAlgorithm.AES);
        }
        catch (Exception e) {
            LOG.error("Could not fetch authorities", (Throwable)e);
        }
        AccessTokenDataBinder.AccessTokenInfo accessTokenInfo = this.accessTokenDataBinder.create(Optional.ofNullable(idToken.getClaim("sid")).map(Object::toString), loginResp.getUsername(), claims, authorities, true);
        loginResp.setAccessToken(accessTokenInfo.jwt());
        loginResp.setAccessTokenExpiryTime(accessTokenInfo.expiration());
        return loginResp;
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public OIDCRequest createLogoutRequest(String accessToken, String redirectURI) {
        JWTClaimsSet claimsSet;
        try {
            SignedJWT jwt = SignedJWT.parse((String)accessToken);
            claimsSet = jwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAccessToken);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        String opName = (String)claimsSet.getClaim(JWT_CLAIM_OP_NAME);
        OIDCC4UIProvider op = (OIDCC4UIProvider)this.opDAO.findByName(opName).orElseThrow(() -> new NotFoundException("OIDC Provider '" + opName + "'"));
        OidcClient oidcClient = this.getOidcClient(this.oidcClientCacheLogout, op, redirectURI);
        OidcProfile profile = new OidcProfile();
        profile.setIdTokenString((String)claimsSet.getClaim(JWT_CLAIM_ID_TOKEN));
        WithLocationAction action = oidcClient.getLogoutAction(new CallContext((WebContext)new OIDCC4UIContext(), (SessionStore)NoOpSessionStore.INSTANCE), (UserProfile)profile, redirectURI).map(WithLocationAction.class::cast).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add("No RedirectionAction generated for LogoutRequest");
            return sce;
        });
        OIDCRequest logoutRequest = new OIDCRequest();
        logoutRequest.setLocation(action.getLocation());
        return logoutRequest;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void backChannelLogout(final String logoutToken, String redirectURI) {
        JWTClaimsSet claimsSet;
        try {
            SignedJWT jwt = SignedJWT.parse((String)logoutToken);
            claimsSet = jwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAccessToken);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        String opName = (String)claimsSet.getAudience().getFirst();
        OIDCC4UIProvider op = (OIDCC4UIProvider)this.opDAO.findByName(opName).orElseThrow(() -> new NotFoundException("OIDC Provider '" + opName + "'"));
        OidcClient oidcClient = this.getOidcClient(this.oidcClientCacheLogout, op, redirectURI);
        Credentials credentials = (Credentials)oidcClient.getCredentials(new CallContext((WebContext)new OIDCC4UIContext(this){

            @Override
            public Optional<String> getRequestParameter(String name) {
                if ("logout_token".equals(name)) {
                    return Optional.of(logoutToken);
                }
                return Optional.empty();
            }
        }, (SessionStore)NoOpSessionStore.INSTANCE)).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add("Could not validate the logout token");
            return sce;
        });
        this.accessTokenDAO.deleteById(((SessionKeyCredentials)credentials).getSessionKey());
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

