/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.elasticsearch.dao;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.DisMaxQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import java.lang.reflect.Field;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.AuxClassCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.utils.FormatUtils;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.persistence.common.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public class ElasticsearchAnySearchDAO
extends AbstractAnySearchDAO {
    protected static final Set<String> ID_PROPS = Set.of("key", "id", "_id");
    protected final ElasticsearchClient client;
    protected final int indexMaxResultWindow;

    public ElasticsearchAnySearchDAO(RealmSearchDAO realmSearchDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, ElasticsearchClient client, int indexMaxResultWindow) {
        super(realmSearchDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator);
        this.client = client;
        this.indexMaxResultWindow = indexMaxResultWindow;
    }

    protected AdminRealmsFilter getAdminRealmsFilter(Realm base, boolean recursive, Set<String> adminRealms) {
        HashSet<Pair<AnyTypeKind, String>> managed = new HashSet<Pair<AnyTypeKind, String>>();
        ArrayList<Query> queries = new ArrayList<Query>();
        if (recursive) {
            adminRealms.forEach(realmPath -> RealmUtils.ManagerRealm.of((String)realmPath).ifPresentOrElse(realm -> managed.add(Pair.of((Object)realm.kind(), (Object)realm.anyKey())), () -> {
                Realm realm = (Realm)this.realmSearchDAO.findByFullPath(realmPath).orElseThrow(() -> {
                    SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
                    noRealm.getElements().add("Invalid realm specified: " + realmPath);
                    return noRealm;
                });
                this.realmSearchDAO.findDescendants(realm.getFullPath(), base.getFullPath()).forEach(descendant -> queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("realm").value(descendant).caseInsensitive(Boolean.valueOf(false)).build()).build()));
            }));
        } else if (adminRealms.stream().anyMatch(r -> r.startsWith(base.getFullPath()))) {
            queries.add((Query)new Query.Builder().term(QueryBuilders.term().field("realm").value(base.getKey()).caseInsensitive(Boolean.valueOf(false)).build()).build());
        }
        return new AdminRealmsFilter(managed.isEmpty() ? Optional.of((Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build()) : Optional.empty(), managed);
    }

    protected Query getQuery(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        Query query;
        if (SyncopeConstants.FULL_ADMIN_REALMS.equals(adminRealms)) {
            query = this.getQuery(cond, kind);
            if (!recursive) {
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().filter((Query)new Query.Builder().term(QueryBuilders.term().field("realm").value(base.getKey()).caseInsensitive(Boolean.valueOf(false)).build()).build(), new Query[0]).filter(query, new Query[0]).build()).build();
            }
        } else {
            AdminRealmsFilter filter = this.getAdminRealmsFilter(base, recursive, adminRealms);
            query = this.getQuery(ElasticsearchAnySearchDAO.buildEffectiveCond((SearchCond)cond, filter.managed(), (AnyTypeKind)kind), kind);
            if (filter.query().isPresent()) {
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().filter(filter.query().get(), new Query[0]).filter(query, new Query[0]).build()).build();
            }
        }
        return query;
    }

    protected long doCount(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        CountRequest request = new CountRequest.Builder().index(ElasticsearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)kind), new String[0]).query(this.getQuery(base, recursive, adminRealms, cond, kind)).build();
        LOG.debug("Count request: {}", (Object)request);
        try {
            return this.client.count(request).count();
        }
        catch (Exception e) {
            LOG.error("While counting in Elasticsearch with request {}", (Object)request, (Object)e);
            return 0L;
        }
    }

    protected List<SortOptions> sortBuilders(AnyTypeKind kind, Stream<Sort.Order> orderBy) {
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(kind);
        ArrayList<SortOptions> options = new ArrayList<SortOptions>();
        orderBy.forEach(clause -> {
            String sortName = null;
            String fieldName = clause.getProperty();
            if (!ID_PROPS.contains(fieldName)) {
                Field anyField = anyUtils.getField(fieldName).orElse(null);
                if (anyField == null) {
                    PlainSchema schema = this.plainSchemaDAO.findById(fieldName).orElse(null);
                    if (schema != null) {
                        sortName = fieldName;
                    }
                } else {
                    sortName = fieldName;
                }
            }
            if (sortName == null) {
                LOG.warn("Cannot build any valid clause from {}", clause);
            } else {
                options.add((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(sortName).order(clause.getDirection() == Sort.Direction.ASC ? SortOrder.Asc : SortOrder.Desc).build()).build());
            }
        });
        return options;
    }

    protected <T extends Any> List<T> doSearch(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, Pageable pageable, AnyTypeKind kind) {
        SearchRequest request = new SearchRequest.Builder().index(ElasticsearchUtils.getAnyIndex((String)AuthContextUtils.getDomain(), (AnyTypeKind)kind), new String[0]).searchType(SearchType.QueryThenFetch).query(this.getQuery(base, recursive, adminRealms, cond, kind)).from(Integer.valueOf(pageable.isUnpaged() ? 0 : pageable.getPageSize() * pageable.getPageNumber())).size(Integer.valueOf(pageable.isUnpaged() ? this.indexMaxResultWindow : pageable.getPageSize())).sort(this.sortBuilders(kind, pageable.getSort().get())).fields(List.of()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).build();
        LOG.debug("Search request: {}", (Object)request);
        List esResult = null;
        try {
            esResult = this.client.search(request, Void.class).hits().hits();
        }
        catch (Exception e) {
            LOG.error("While searching in Elasticsearch with request {}", (Object)request, (Object)e);
        }
        return CollectionUtils.isEmpty((Collection)esResult) ? List.of() : this.buildResult(esResult.stream().map(Hit::id).collect(Collectors.toList()), kind);
    }

    protected Query getQuery(SearchCond cond, AnyTypeKind kind) {
        Query query = null;
        switch (cond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                query = cond.asLeaf(AnyTypeCond.class).filter(leaf -> AnyTypeKind.ANY_OBJECT == kind).map(this::getQuery).orElse(null);
                if (query == null) {
                    query = cond.asLeaf(RelationshipTypeCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(RelationshipCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(MembershipCond.class).filter(leaf -> AnyTypeKind.GROUP != kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(MemberCond.class).filter(leaf -> AnyTypeKind.GROUP == kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(RoleCond.class).filter(leaf -> AnyTypeKind.USER == kind).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(AuxClassCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(ResourceCond.class).map(this::getQuery).orElse(null);
                }
                if (query == null) {
                    query = cond.asLeaf(AnyCond.class).map(ac -> this.getQuery((AnyCond)ac, kind)).or(() -> cond.asLeaf(AttrCond.class).map(this::getQuery)).orElse(null);
                }
                if (query == null) {
                    query = this.getQueryForCustomConds(cond, kind);
                }
                if (query == null) {
                    throw new IllegalArgumentException("Cannot construct QueryBuilder");
                }
                if (cond.getType() != SearchCond.Type.NOT_LEAF) break;
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().mustNot(query, new Query[0]).build()).build();
                break;
            }
            case AND: {
                ArrayList<Query> andCompound = new ArrayList<Query>();
                Query andLeft = this.getQuery(cond.getLeft(), kind);
                if (andLeft._kind() == Query.Kind.Bool && !((BoolQuery)andLeft._get()).filter().isEmpty()) {
                    andCompound.addAll(((BoolQuery)andLeft._get()).filter());
                } else {
                    andCompound.add(andLeft);
                }
                Query andRight = this.getQuery(cond.getRight(), kind);
                if (andRight._kind() == Query.Kind.Bool && !((BoolQuery)andRight._get()).filter().isEmpty()) {
                    andCompound.addAll(((BoolQuery)andRight._get()).filter());
                } else {
                    andCompound.add(andRight);
                }
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().filter(andCompound).build()).build();
                break;
            }
            case OR: {
                ArrayList<Query> orCompound = new ArrayList<Query>();
                Query orLeft = this.getQuery(cond.getLeft(), kind);
                if (orLeft._kind() == Query.Kind.DisMax) {
                    orCompound.addAll(((DisMaxQuery)orLeft._get()).queries());
                } else {
                    orCompound.add(orLeft);
                }
                Query orRight = this.getQuery(cond.getRight(), kind);
                if (orRight._kind() == Query.Kind.DisMax) {
                    orCompound.addAll(((DisMaxQuery)orRight._get()).queries());
                } else {
                    orCompound.add(orRight);
                }
                query = (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(orCompound).build()).build();
                break;
            }
        }
        return query;
    }

    protected Query getQuery(AnyTypeCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("anyType").value(cond.getAnyTypeKey()).build()).build();
    }

    protected Query getQuery(RelationshipTypeCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("relationshipTypes").value(cond.getRelationshipTypeKey()).caseInsensitive(Boolean.valueOf(false)).build()).build();
    }

    protected Query getQuery(RelationshipCond cond) {
        List<Query> queries = this.check(cond).stream().map(key -> (Query)new Query.Builder().term(QueryBuilders.term().field("relationships").value(key).caseInsensitive(Boolean.valueOf(false)).build()).build()).toList();
        return queries.size() == 1 ? queries.getFirst() : (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build();
    }

    protected Query getQuery(MembershipCond cond) {
        List<Query> queries = this.check(cond).stream().map(key -> (Query)new Query.Builder().term(QueryBuilders.term().field("memberships").value(key).caseInsensitive(Boolean.valueOf(false)).build()).build()).toList();
        return queries.size() == 1 ? queries.getFirst() : (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build();
    }

    protected Query getQuery(RoleCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("roles").value(cond.getRole()).caseInsensitive(Boolean.valueOf(false)).build()).build();
    }

    protected Query getQuery(MemberCond cond) {
        List<Query> queries = this.check(cond).stream().map(key -> (Query)new Query.Builder().term(QueryBuilders.term().field("members").value(key).caseInsensitive(Boolean.valueOf(false)).build()).build()).toList();
        return queries.size() == 1 ? queries.getFirst() : (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(queries).build()).build();
    }

    protected Query getQuery(AuxClassCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("auxClasses").value(cond.getAuxClass()).caseInsensitive(Boolean.valueOf(false)).build()).build();
    }

    protected Query getQuery(ResourceCond cond) {
        return (Query)new Query.Builder().term(QueryBuilders.term().field("resources").value(cond.getResource()).caseInsensitive(Boolean.valueOf(false)).build()).build();
    }

    protected Query fillAttrQuery(PlainSchema schema, PlainAttrValue attrValue, AttrCond cond) {
        Object value = schema.getType() == AttrSchemaType.Date && attrValue.getDateValue() != null ? FormatUtils.format((TemporalAccessor)attrValue.getDateValue()) : attrValue.getValue();
        Query query = null;
        switch (cond.getType()) {
            case ISNOTNULL: {
                query = (Query)new Query.Builder().exists(QueryBuilders.exists().field(schema.getKey()).build()).build();
                break;
            }
            case ISNULL: {
                query = (Query)new Query.Builder().bool(QueryBuilders.bool().mustNot((Query)new Query.Builder().exists(QueryBuilders.exists().field(schema.getKey()).build()).build(), new Query[0]).build()).build();
                break;
            }
            case ILIKE: {
                query = (Query)new Query.Builder().wildcard(QueryBuilders.wildcard().field(schema.getKey()).value(cond.getExpression().replace('%', '*').replace("\\_", "_")).caseInsensitive(Boolean.valueOf(true)).build()).build();
                break;
            }
            case LIKE: {
                query = (Query)new Query.Builder().wildcard(QueryBuilders.wildcard().field(schema.getKey()).value(cond.getExpression().replace('%', '*').replace("\\_", "_")).caseInsensitive(Boolean.valueOf(false)).build()).build();
                break;
            }
            case IEQ: {
                query = (Query)new Query.Builder().term(QueryBuilders.term().field(schema.getKey()).value(cond.getExpression()).caseInsensitive(Boolean.valueOf(true)).build()).build();
                break;
            }
            case EQ: {
                FieldValue fieldValue;
                if (value instanceof Double) {
                    Double aDouble = (Double)value;
                    fieldValue = FieldValue.of((Object)aDouble);
                } else if (value instanceof Long) {
                    Long aLong = (Long)value;
                    fieldValue = FieldValue.of((Object)aLong);
                } else if (value instanceof Boolean) {
                    Boolean aBoolean = (Boolean)value;
                    fieldValue = FieldValue.of((Object)aBoolean);
                } else {
                    fieldValue = FieldValue.of((String)value.toString());
                }
                query = (Query)new Query.Builder().term(QueryBuilders.term().field(schema.getKey()).value(fieldValue).caseInsensitive(Boolean.valueOf(false)).build()).build();
                break;
            }
            case GE: {
                query = (Query)new Query.Builder().range(RangeQuery.of(r -> r.untyped(n -> (ObjectBuilder)n.field(schema.getKey()).gte((Object)JsonData.of((Object)value))))).build();
                break;
            }
            case GT: {
                query = (Query)new Query.Builder().range(RangeQuery.of(r -> r.untyped(n -> (ObjectBuilder)n.field(schema.getKey()).gt((Object)JsonData.of((Object)value))))).build();
                break;
            }
            case LE: {
                query = (Query)new Query.Builder().range(RangeQuery.of(r -> r.untyped(n -> (ObjectBuilder)n.field(schema.getKey()).lte((Object)JsonData.of((Object)value))))).build();
                break;
            }
            case LT: {
                query = (Query)new Query.Builder().range(RangeQuery.of(r -> r.untyped(n -> (ObjectBuilder)n.field(schema.getKey()).lt((Object)JsonData.of((Object)value))))).build();
                break;
            }
        }
        return query;
    }

    protected Query getQuery(AttrCond cond) {
        AbstractAnySearchDAO.CheckResult checked = this.check(cond);
        return this.fillAttrQuery(checked.schema(), checked.value(), cond);
    }

    protected AbstractAnySearchDAO.CheckResult<AnyCond> check(AnyCond cond, AnyTypeKind kind) {
        AbstractAnySearchDAO.CheckResult checked = super.check(cond, kind);
        if ("id".equals(((AnyCond)checked.cond()).getSchema())) {
            ((AnyCond)checked.cond()).setSchema("_id");
        }
        if ("id".equals(checked.schema().getKey())) {
            checked.schema().setKey("_id");
        }
        return checked;
    }

    protected Query getQuery(AnyCond cond, AnyTypeKind kind) {
        if ("realm".equals(cond.getSchema()) && cond.getExpression().startsWith("/")) {
            Realm realm = (Realm)this.realmSearchDAO.findByFullPath(cond.getExpression()).orElseThrow(() -> new IllegalArgumentException("Invalid Realm full path: " + cond.getExpression()));
            cond.setExpression(realm.getKey());
        }
        AbstractAnySearchDAO.CheckResult<AnyCond> checked = this.check(cond, kind);
        return this.fillAttrQuery(checked.schema(), checked.value(), checked.cond());
    }

    protected Query getQueryForCustomConds(SearchCond cond, AnyTypeKind kind) {
        return null;
    }

    protected record AdminRealmsFilter(Optional<Query> query, Set<Pair<AnyTypeKind, String>> managed) {
    }
}

