/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AuditEventDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.elasticsearch.dao.ElasticsearchAnySearchDAO;
import org.apache.syncope.core.persistence.elasticsearch.dao.ElasticsearchAuditEventDAO;
import org.apache.syncope.core.persistence.elasticsearch.dao.ElasticsearchRealmSearchDAO;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchIndexManager;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
public class ElasticsearchPersistenceContext {
    @ConditionalOnMissingBean(name={"elasticsearchAnySearchDAO"})
    @Bean
    public AnySearchDAO anySearchDAO(RealmSearchDAO realmSearchDAO, @Lazy DynRealmDAO dynRealmDAO, @Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, ElasticsearchClient client, ElasticsearchProperties props) {
        return new ElasticsearchAnySearchDAO(realmSearchDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, client, props.getIndexMaxResultWindow());
    }

    @ConditionalOnMissingBean(name={"elasticsearchRealmSearchDAO"})
    @Bean
    public RealmSearchDAO realmSearchDAO(@Lazy RealmDAO realmDAO, ElasticsearchClient client, ElasticsearchProperties props) {
        return new ElasticsearchRealmSearchDAO(realmDAO, client, props.getIndexMaxResultWindow());
    }

    @ConditionalOnMissingBean(name={"elasticsearchAuditEventDAO"})
    @Bean
    public AuditEventDAO auditEventDAO(ElasticsearchIndexManager indexManager, ElasticsearchClient client, ElasticsearchProperties props) {
        return new ElasticsearchAuditEventDAO(indexManager, client, props.getIndexMaxResultWindow());
    }
}

