/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.elasticsearch.dao;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch._types.ScriptSortType;
import co.elastic.clients.elasticsearch._types.ScriptSource;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.MalformedPathException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class ElasticsearchRealmSearchDAO
implements RealmSearchDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(RealmDAO.class);
    protected static final List<SortOptions> REALM_SORT_OPTIONS = List.of((SortOptions)new SortOptions.Builder().script(s -> s.type(ScriptSortType.Number).script(t -> t.lang(ScriptLanguage.Painless).source((ScriptSource)new ScriptSource.Builder().scriptString("doc['fullPath'].value.chars().filter(ch -> ch == '/').count()").build())).order(SortOrder.Asc)).build());
    protected final RealmDAO realmDAO;
    protected final ElasticsearchClient client;
    protected final int indexMaxResultWindow;

    public ElasticsearchRealmSearchDAO(RealmDAO realmDAO, ElasticsearchClient client, int indexMaxResultWindow) {
        this.realmDAO = realmDAO;
        this.client = client;
        this.indexMaxResultWindow = indexMaxResultWindow;
    }

    @Transactional(readOnly=true)
    public Optional<Realm> findByFullPath(String fullPath) {
        if ("/".equals(fullPath)) {
            return Optional.of(this.realmDAO.getRoot());
        }
        if (StringUtils.isBlank((CharSequence)fullPath) || !RealmDAO.PATH_PATTERN.matcher(fullPath).matches()) {
            throw new MalformedPathException(fullPath);
        }
        SearchRequest request = new SearchRequest.Builder().index(ElasticsearchUtils.getRealmIndex((String)AuthContextUtils.getDomain()), new String[0]).searchType(SearchType.QueryThenFetch).query((Query)new Query.Builder().term(QueryBuilders.term().field("fullPath").value(fullPath).build()).build()).size(Integer.valueOf(1)).fields(List.of()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).build();
        LOG.debug("Search request: {}", (Object)request);
        try {
            String result = this.client.search(request, Void.class).hits().hits().stream().findFirst().map(Hit::id).orElse(null);
            return this.realmDAO.findById(result).map(Realm.class::cast);
        }
        catch (Exception e) {
            LOG.error("While searching Elasticsearch for Realm path {} with request {}", new Object[]{fullPath, request, e});
            return Optional.empty();
        }
    }

    protected List<String> search(Query query) {
        SearchRequest request = new SearchRequest.Builder().index(ElasticsearchUtils.getRealmIndex((String)AuthContextUtils.getDomain()), new String[0]).searchType(SearchType.QueryThenFetch).query(query).sort(REALM_SORT_OPTIONS).fields(List.of()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).build();
        LOG.debug("Search request: {}", (Object)request);
        try {
            return this.client.search(request, Void.class).hits().hits().stream().map(Hit::id).toList();
        }
        catch (Exception e) {
            LOG.error("While searching in Elasticsearch with request {}", (Object)request, (Object)e);
            return List.of();
        }
    }

    public List<Realm> findByName(String name) {
        List<String> result = this.search((Query)new Query.Builder().term(QueryBuilders.term().field("name").value(name).build()).build());
        return result.stream().map(arg_0 -> ((RealmDAO)this.realmDAO).findById(arg_0)).flatMap(Optional::stream).map(Realm.class::cast).toList();
    }

    public List<Realm> findChildren(Realm realm) {
        List<String> result = this.search((Query)new Query.Builder().term(QueryBuilders.term().field("parent_id").value(realm.getKey()).build()).build());
        return result.stream().map(arg_0 -> ((RealmDAO)this.realmDAO).findById(arg_0)).flatMap(Optional::stream).map(Realm.class::cast).toList();
    }

    protected Query buildDescendantsQuery(Set<String> bases, String keyword) {
        ArrayList basesQueries = new ArrayList();
        bases.forEach(base -> {
            basesQueries.add((Query)new Query.Builder().term(QueryBuilders.term().field("fullPath").value(base).build()).build());
            basesQueries.add((Query)new Query.Builder().regexp(QueryBuilders.regexp().field("fullPath").value((String)("/".equals(base) ? "/.*" : base + "/.*")).build()).build());
        });
        Query prefix = (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries(basesQueries).build()).build();
        if (keyword == null) {
            return prefix;
        }
        StringBuilder output = new StringBuilder();
        for (char c : keyword.toLowerCase().toCharArray()) {
            if (c == '%') {
                output.append(".*");
                continue;
            }
            if (Character.isLetter(c)) {
                output.append('[').append(c).append(Character.toUpperCase(c)).append(']');
                continue;
            }
            output.append(ElasticsearchUtils.escapeForLikeRegex((char)c));
        }
        return (Query)new Query.Builder().bool(QueryBuilders.bool().filter(prefix, new Query[]{(Query)new Query.Builder().regexp(QueryBuilders.regexp().field("name").value(output.toString()).build()).build()}).build()).build();
    }

    public long countDescendants(String base, String keyword) {
        return this.countDescendants(Set.of(base), keyword);
    }

    public long countDescendants(Set<String> bases, String keyword) {
        CountRequest request = new CountRequest.Builder().index(ElasticsearchUtils.getRealmIndex((String)AuthContextUtils.getDomain()), new String[0]).query(this.buildDescendantsQuery(bases, keyword)).build();
        LOG.debug("Count request: {}", (Object)request);
        try {
            return this.client.count(request).count();
        }
        catch (Exception e) {
            LOG.error("While counting in Elasticsearch with request {}", (Object)request, (Object)e);
            return 0L;
        }
    }

    public List<Realm> findDescendants(String base, String keyword, Pageable pageable) {
        return this.findDescendants(Set.of(base), keyword, pageable);
    }

    public List<Realm> findDescendants(Set<String> bases, String keyword, Pageable pageable) {
        SearchRequest request = new SearchRequest.Builder().index(ElasticsearchUtils.getRealmIndex((String)AuthContextUtils.getDomain()), new String[0]).searchType(SearchType.QueryThenFetch).query(this.buildDescendantsQuery(bases, keyword)).from(Integer.valueOf(pageable.isUnpaged() ? 0 : pageable.getPageSize() * pageable.getPageNumber())).size(Integer.valueOf(pageable.isUnpaged() ? this.indexMaxResultWindow : pageable.getPageSize())).sort(REALM_SORT_OPTIONS).fields(List.of()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).build();
        LOG.debug("Search request: {}", (Object)request);
        List<Object> result = List.of();
        try {
            result = this.client.search(request, Void.class).hits().hits().stream().map(Hit::id).toList();
        }
        catch (Exception e) {
            LOG.error("While searching in Elasticsearch with request {}", (Object)request, (Object)e);
        }
        return result.stream().map(arg_0 -> ((RealmDAO)this.realmDAO).findById(arg_0)).flatMap(Optional::stream).map(Realm.class::cast).toList();
    }

    public List<String> findDescendants(String base, String prefix) {
        Query prefixQuery = (Query)new Query.Builder().disMax(QueryBuilders.disMax().queries((Query)new Query.Builder().term(QueryBuilders.term().field("fullPath").value(prefix).build()).build(), new Query[]{(Query)new Query.Builder().prefix(QueryBuilders.prefix().field("fullPath").value((String)("/".equals(prefix) ? "/" : prefix + "/")).build()).build()}).build()).build();
        Query query = (Query)new Query.Builder().bool(QueryBuilders.bool().filter(this.buildDescendantsQuery(Set.of(base), null), new Query[]{prefixQuery}).build()).build();
        SearchRequest request = new SearchRequest.Builder().index(ElasticsearchUtils.getRealmIndex((String)AuthContextUtils.getDomain()), new String[0]).searchType(SearchType.QueryThenFetch).query(query).from(Integer.valueOf(0)).size(Integer.valueOf(this.indexMaxResultWindow)).sort(REALM_SORT_OPTIONS).fields(List.of()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build()).build();
        LOG.debug("Search request: {}", (Object)request);
        List<String> result = List.of();
        try {
            result = this.client.search(request, Void.class).hits().hits().stream().map(Hit::id).toList();
        }
        catch (Exception e) {
            LOG.error("While searching in Elasticsearch with request {}", (Object)request, (Object)e);
        }
        return result;
    }
}

