/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.elasticsearch.client;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AuditEvent;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class ElasticsearchUtils {
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;

    public static String getAnyIndex(String domain, AnyTypeKind kind) {
        return domain.toLowerCase() + "_" + kind.name().toLowerCase();
    }

    public static String getRealmIndex(String domain) {
        return domain.toLowerCase() + "_realm";
    }

    public static String getAuditIndex(String domain) {
        return domain.toLowerCase() + "_audit";
    }

    public ElasticsearchUtils(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO) {
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
    }

    protected void relationships(List<? extends Relationship<?, ?>> input, Map<String, Object> builder) {
        ArrayList relationships = new ArrayList();
        ArrayList relationshipTypes = new ArrayList();
        input.forEach(relationship -> {
            relationships.add(relationship.getRightEnd().getKey());
            relationshipTypes.add(relationship.getType().getKey());
        });
        builder.put("relationships", relationships);
        builder.put("relationshipTypes", relationshipTypes);
    }

    @Transactional
    public Map<String, Object> document(Any any) {
        HashMap<String, Object> builder = new HashMap<String, Object>();
        builder.put("realm", any.getRealm().getKey());
        builder.put("anyType", any.getType().getKey());
        builder.put("creationDate", any.getCreationDate());
        builder.put("creationContext", any.getCreationContext());
        builder.put("creator", any.getCreator());
        builder.put("lastChangeDate", any.getLastChangeDate());
        builder.put("lastModifier", any.getLastModifier());
        builder.put("lastChangeContext", any.getLastChangeContext());
        builder.put("status", any.getStatus());
        builder.put("auxClasses", any.getAuxClasses().stream().map(Entity::getKey).toList());
        Optional.ofNullable(any.getUManager()).ifPresent(um -> builder.put("uManager", um.getKey()));
        Optional.ofNullable(any.getGManager()).ifPresent(gm -> builder.put("gManager", gm.getKey()));
        Any any2 = any;
        Objects.requireNonNull(any2);
        Any any3 = any2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnyObject.class, Group.class, User.class}, (Object)any3, n)) {
            case 0: {
                AnyObject anyObject = (AnyObject)any3;
                builder.put("name", anyObject.getName());
                builder.put("memberships", this.anyObjectDAO.findAllGroupKeys(anyObject));
                this.relationships(this.anyObjectDAO.findAllRelationships(anyObject), builder);
                builder.put("resources", this.anyObjectDAO.findAllResourceKeys(anyObject.getKey()));
                this.customizeDocument(builder, anyObject);
                break;
            }
            case 1: {
                Group group = (Group)any3;
                builder.put("name", group.getName());
                HashSet<String> members = new HashSet<String>();
                members.addAll(this.groupDAO.findUMemberships(group, Pageable.unpaged()).stream().map(membership -> ((User)membership.getLeftEnd()).getKey()).toList());
                members.addAll(this.groupDAO.findAMemberships(group).stream().map(membership -> ((AnyObject)membership.getLeftEnd()).getKey()).toList());
                builder.put("members", members);
                this.relationships(group.getRelationships(), builder);
                builder.put("resources", this.groupDAO.findAllResourceKeys(group.getKey()));
                this.customizeDocument(builder, group);
                break;
            }
            case 2: {
                User user = (User)any3;
                builder.put("username", user.getUsername());
                builder.put("token", user.getToken());
                builder.put("tokenExpireTime", user.getTokenExpireTime());
                builder.put("changePwdDate", user.getChangePwdDate());
                builder.put("failedLogins", user.getFailedLogins());
                builder.put("lastLoginDate", user.getLastLoginDate());
                builder.put("suspended", user.isSuspended());
                builder.put("mustChangePassword", user.isMustChangePassword());
                builder.put("roles", this.userDAO.findAllRoles(user).stream().map(Entity::getKey).toList());
                builder.put("memberships", this.userDAO.findAllGroupKeys(user));
                this.relationships(user.getRelationships(), builder);
                builder.put("resources", this.userDAO.findAllResourceKeys(user.getKey()));
                this.customizeDocument(builder, user);
                break;
            }
        }
        for (PlainAttr plainAttr : any.getPlainAttrs()) {
            List values = plainAttr.getValues().stream().map(PlainAttrValue::getValue).collect(Collectors.toList());
            Optional.ofNullable(plainAttr.getUniqueValue()).ifPresent(v -> values.add(v.getValue()));
            builder.put(plainAttr.getSchema(), values.size() == 1 ? values.getFirst() : values);
        }
        if (any instanceof Groupable) {
            Groupable groupable = (Groupable)any;
            groupable.getMemberships().forEach(m -> groupable.getPlainAttrs(m).forEach(mAttr -> {
                List values = mAttr.getValues().stream().map(PlainAttrValue::getValue).collect(Collectors.toList());
                Optional.ofNullable(mAttr.getUniqueValue()).ifPresent(v -> values.add(v.getValue()));
                Object attr = builder.computeIfAbsent(mAttr.getSchema(), k -> new HashSet());
                if (attr instanceof Collection) {
                    ((Collection)attr).addAll(values);
                } else {
                    values.add(attr);
                    builder.put(mAttr.getSchema(), values.size() == 1 ? values.getFirst() : values);
                }
            }));
        }
        return builder;
    }

    protected void customizeDocument(Map<String, Object> builder, AnyObject anyObject) {
    }

    protected void customizeDocument(Map<String, Object> builder, Group group) {
    }

    protected void customizeDocument(Map<String, Object> builder, User user) {
    }

    public Map<String, Object> document(Realm realm) {
        HashMap<String, Object> builder = new HashMap<String, Object>();
        builder.put("name", realm.getName());
        builder.put("parent_id", realm.getParent() == null ? null : realm.getParent().getKey());
        builder.put("fullPath", realm.getFullPath());
        this.customizeDocument(builder, realm);
        return builder;
    }

    protected void customizeDocument(Map<String, Object> builder, Realm realm) {
    }

    public Map<String, Object> document(AuditEvent auditEvent) {
        HashMap<String, Object> builder = new HashMap<String, Object>();
        builder.put("key", auditEvent.getKey());
        builder.put("opEvent", auditEvent.getOpEvent());
        builder.put("who", auditEvent.getWho());
        builder.put("when", auditEvent.getWhen());
        builder.put("before", auditEvent.getBefore());
        builder.put("inputs", auditEvent.getInputs());
        builder.put("output", auditEvent.getOutput());
        builder.put("throwable", auditEvent.getThrowable());
        this.customizeDocument(builder, auditEvent);
        return builder;
    }

    protected void customizeDocument(Map<String, Object> builder, AuditEvent auditEvent) {
    }
}

