/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.elasticsearch.client;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest5_client.Rest5ClientTransport;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import co.elastic.clients.transport.rest5_client.low_level.Rest5ClientBuilder;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class ElasticsearchClientFactoryBean
implements FactoryBean<ElasticsearchClient>,
DisposableBean {
    private final List<HttpHost> hosts;
    private String username;
    private String password;
    private String serviceToken;
    private String apiKeyId;
    private String apiKeySecret;
    private Rest5Client restClient;
    private ElasticsearchClient client;

    public ElasticsearchClientFactoryBean(List<HttpHost> hosts) {
        this.hosts = hosts;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServiceToken() {
        return this.serviceToken;
    }

    public void setServiceToken(String serviceToken) {
        this.serviceToken = serviceToken;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public void setApiKeyId(String apiKeyId) {
        this.apiKeyId = apiKeyId;
    }

    public String getApiKeySecret() {
        return this.apiKeySecret;
    }

    public void setApiKeySecret(String apiKeySecret) {
        this.apiKeySecret = apiKeySecret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElasticsearchClient getObject() {
        ElasticsearchClientFactoryBean elasticsearchClientFactoryBean = this;
        synchronized (elasticsearchClientFactoryBean) {
            if (this.client == null) {
                Rest5ClientBuilder builder = Rest5Client.builder((HttpHost[])((HttpHost[])this.hosts.toArray(HttpHost[]::new)));
                if (this.username != null && this.password != null) {
                    String encodedAuth = Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8));
                    builder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", (Object)("Bearer " + encodedAuth))});
                } else if (this.serviceToken != null) {
                    builder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", (Object)("Bearer " + this.serviceToken))});
                } else if (this.apiKeyId != null && this.apiKeySecret != null) {
                    String apiKeyAuth = Base64.getEncoder().encodeToString((this.apiKeyId + ":" + this.apiKeySecret).getBytes(StandardCharsets.UTF_8));
                    builder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", (Object)("ApiKey " + apiKeyAuth))});
                }
                this.restClient = builder.build();
                this.client = new ElasticsearchClient((ElasticsearchTransport)new Rest5ClientTransport(this.restClient, (JsonpMapper)new JacksonJsonpMapper(((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build())));
            }
        }
        return this.client;
    }

    public Class<?> getObjectType() {
        return ElasticsearchClient.class;
    }

    public void destroy() throws Exception {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }
}

