/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.elasticsearch.client;

import javax.sql.DataSource;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchIndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchIndexLoader
implements SyncopeCoreLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(ElasticsearchIndexLoader.class);
    protected final ElasticsearchIndexManager indexManager;

    public ElasticsearchIndexLoader(ElasticsearchIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void load(String domain, DataSource datasource) {
        try {
            if (!this.indexManager.existsAnyIndex(domain, AnyTypeKind.USER)) {
                this.indexManager.createAnyIndex(domain, AnyTypeKind.USER, this.indexManager.defaultSettings(), this.indexManager.defaultAnyMapping());
            }
            if (!this.indexManager.existsAnyIndex(domain, AnyTypeKind.GROUP)) {
                this.indexManager.createAnyIndex(domain, AnyTypeKind.GROUP, this.indexManager.defaultSettings(), this.indexManager.defaultAnyMapping());
            }
            if (!this.indexManager.existsAnyIndex(domain, AnyTypeKind.ANY_OBJECT)) {
                this.indexManager.createAnyIndex(domain, AnyTypeKind.ANY_OBJECT, this.indexManager.defaultSettings(), this.indexManager.defaultAnyMapping());
            }
            if (!this.indexManager.existsRealmIndex(domain)) {
                this.indexManager.createRealmIndex(domain, this.indexManager.defaultSettings(), this.indexManager.defaultRealmMapping());
            }
            if (!this.indexManager.existsAuditIndex(domain)) {
                this.indexManager.createAuditIndex(domain, this.indexManager.defaultSettings(), this.indexManager.defaultAuditMapping());
            }
        }
        catch (Exception e) {
            LOG.error("While creating indexes for domain {}", (Object)domain, (Object)e);
        }
    }
}

