/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public class DateParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (OffsetDateTime.class.equals(rawType)) {
            return new OffsetDateTimeParamConverter();
        }
        if (LocalDateTime.class.equals(rawType)) {
            return new LocalDateTimeParamConverter();
        }
        return null;
    }

    protected static class LocalDateTimeParamConverter
    implements ParamConverter<LocalDateTime> {
        protected LocalDateTimeParamConverter() {
        }

        public LocalDateTime fromString(String value) {
            try {
                return LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Unparsable date: " + value, e);
            }
        }

        public String toString(LocalDateTime value) {
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(value);
        }
    }

    protected static class OffsetDateTimeParamConverter
    implements ParamConverter<OffsetDateTime> {
        protected OffsetDateTimeParamConverter() {
        }

        public OffsetDateTime fromString(String value) {
            try {
                return OffsetDateTime.parse(value, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Unparsable date: " + value, e);
            }
        }

        public String toString(OffsetDateTime value) {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value);
        }
    }
}

