/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.EncryptedFieldPanel;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class DomainAdminCredentialsPanel
extends AbstractModalPanel<Domain> {
    private static final long serialVersionUID = 2893133457496751451L;
    @SpringBean
    private DomainOps domainOps;
    private final Domain domain;

    public DomainAdminCredentialsPanel(Domain domain, BaseModal<Domain> modal, PageReference pageRef) {
        super(modal, pageRef);
        this.domain = domain;
        AjaxDropDownChoicePanel adminCipherAlgorithm = new AjaxDropDownChoicePanel("adminCipherAlgorithm", "adminCipherAlgorithm", (IModel)new PropertyModel((Object)domain, "adminCipherAlgorithm"), false);
        adminCipherAlgorithm.setChoices(List.of(CipherAlgorithm.values()));
        adminCipherAlgorithm.addRequiredLabel();
        adminCipherAlgorithm.setNullValid(false);
        this.add(new Component[]{adminCipherAlgorithm});
        EncryptedFieldPanel adminPassword = new EncryptedFieldPanel("adminPassword", "adminPassword", (IModel)new PropertyModel((Object)domain, "adminPassword"), false);
        adminPassword.setRequired(true);
        this.add(new Component[]{adminPassword});
    }

    @Override
    public Domain getItem() {
        return this.domain;
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        try {
            this.domainOps.changeAdminPassword(this.domain.getKey(), this.domain.getAdminPassword(), this.domain.getAdminCipherAlgorithm());
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While updating domain", (Throwable)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

