/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.role;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.DynRealmRestClient;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSearchFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.role.RoleWrapper;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;

public class RoleWizardBuilder
extends BaseAjaxWizardBuilder<RoleWrapper> {
    private static final long serialVersionUID = 5945391813567245081L;
    protected final RoleRestClient roleRestClient;
    protected final RealmRestClient realmRestClient;
    protected final DynRealmRestClient dynRealmRestClient;

    public RoleWizardBuilder(RoleTO roleTO, RoleRestClient roleRestClient, RealmRestClient realmRestClient, DynRealmRestClient dynRealmRestClient, PageReference pageRef) {
        super(new RoleWrapper(roleTO), pageRef);
        this.roleRestClient = roleRestClient;
        this.realmRestClient = realmRestClient;
        this.dynRealmRestClient = dynRealmRestClient;
    }

    public AjaxWizardBuilder<RoleWrapper> setItem(RoleWrapper item) {
        return (AjaxWizardBuilder)(item != null ? super.setItem((Serializable)((Object)new RoleWrapper((RoleTO)item.getInnerObject()))) : super.setItem(null));
    }

    protected Serializable onApplyInternal(RoleWrapper modelObject) {
        modelObject.fillDynamicConditions();
        if (this.getOriginalItem() == null || ((RoleWrapper)((Object)this.getOriginalItem())).getInnerObject() == null || StringUtils.isBlank((CharSequence)((RoleTO)((RoleWrapper)((Object)this.getOriginalItem())).getInnerObject()).getKey())) {
            this.roleRestClient.create((RoleTO)modelObject.getInnerObject());
        } else {
            this.roleRestClient.update((RoleTO)modelObject.getInnerObject());
        }
        return null;
    }

    protected WizardModel buildModelSteps(RoleWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        wizardModel.add((IWizardStep)new Entitlements((RoleTO)modelObject.getInnerObject()));
        wizardModel.add((IWizardStep)new Realms((RoleTO)modelObject.getInnerObject()));
        wizardModel.add((IWizardStep)new DynRealms((RoleTO)modelObject.getInnerObject()));
        return wizardModel;
    }

    protected class Details
    extends WizardStep {
        private static final long serialVersionUID = 5514523040031722255L;

        public Details(final RoleWrapper modelObject) {
            this.add(new Component[]{new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)modelObject.getInnerObject(), "key"), false).setEnabled(StringUtils.isEmpty((CharSequence)((RoleTO)modelObject.getInnerObject()).getKey()))});
            this.add(new Component[]{new Accordion("dynMembershipCond", List.of(new AbstractTab((IModel)new ResourceModel("dynMembershipCond", "Dynamic USER Membership Conditions")){
                private static final long serialVersionUID = 1037272333056449378L;

                public Panel getPanel(String panelId) {
                    return new UserSearchPanel.Builder((IModel<List<SearchClause>>)new PropertyModel((Object)modelObject, "dynClauses"), RoleWizardBuilder.this.pageRef).required(true).build(panelId);
                }
            }), (IModel)Model.of((Serializable)Integer.valueOf(StringUtils.isBlank((CharSequence)modelObject.getDynMembershipCond()) ? -1 : 0))).setOutputMarkupId(true)});
        }
    }

    protected class Entitlements
    extends WizardStep {
        private static final long serialVersionUID = 5514523040031722256L;

        public Entitlements(final RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("entitlements"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().build("entitlements", (IModel)new PropertyModel<List<String>>((Object)modelObject, "entitlements"){
                private static final long serialVersionUID = -7809699384012595307L;

                public List<String> getObject() {
                    return new ArrayList<String>(modelObject.getEntitlements());
                }

                public void setObject(List<String> object) {
                    modelObject.getEntitlements().clear();
                    modelObject.getEntitlements().addAll(object);
                }
            }, (IModel)new ListModel(RoleWizardBuilder.this.roleRestClient.getAllAvailableEntitlements())).hideLabel().setOutputMarkupId(true)});
        }
    }

    protected class Realms
    extends WizardStep {
        private static final long serialVersionUID = 5514523040031722257L;

        public Realms(RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("realms"));
            final boolean fullRealmsTree = SyncopeWebApplication.get().fullRealmsTree(RoleWizardBuilder.this.realmRestClient);
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(fullRealmsTree);
            settings.setShowListOnEmptyInput(fullRealmsTree);
            AjaxSearchFieldPanel realm = new AjaxSearchFieldPanel("panel", "realm", (IModel)new Model(), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                @Override
                protected Iterator<String> getChoices(String input) {
                    return RoleWizardBuilder.this.realmRestClient.search(fullRealmsTree ? RealmsUtils.buildBaseQuery() : RealmsUtils.buildKeywordQuery(input)).getResult().stream().map(RealmTO::getFullPath).iterator();
                }
            };
            this.add(new Component[]{new MultiFieldPanel.Builder(new PropertyModel((Object)modelObject, "realms")).build("realms", "realms", (FieldPanel)realm).hideLabel()});
        }
    }

    protected class DynRealms
    extends WizardStep {
        private static final long serialVersionUID = 6846234574424462255L;

        public DynRealms(RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("dynRealms"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().build("dynRealms", (IModel)new PropertyModel((Object)modelObject, "dynRealms"), (IModel)new ListModel(RoleWizardBuilder.this.dynRealmRestClient.list().stream().map(DynRealmTO::getKey).collect(Collectors.toList()))).hideLabel().setOutputMarkupId(true)});
        }
    }
}

