/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.client.console.PreferenceManager;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.AnyDataProvider;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.DisplayAttributesModalPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.AttrColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.TokenColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wizards.any.StatusPanel;
import org.apache.syncope.client.ui.commons.status.ConnObjectWrapper;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.util.ReflectionUtils;

public abstract class AnyDirectoryPanel<A extends AnyTO, E extends AbstractAnyRestClient<A>>
extends DirectoryPanel<A, AnyWrapper<A>, AnyDataProvider<A>, E> {
    private static final long serialVersionUID = -1100228004207271270L;
    @SpringBean
    protected SchemaRestClient schemaRestClient;
    @SpringBean
    protected AuditRestClient auditRestClient;
    protected final List<PlainSchemaTO> plainSchemas;
    protected final List<DerSchemaTO> derSchemas;
    protected String fiql;
    protected final String realm;
    protected final String type;
    protected final BaseModal<Serializable> utilityModal = new BaseModal("outer");

    protected AnyDirectoryPanel(String id, Builder<A, E> builder) {
        this(id, builder, true);
    }

    protected AnyDirectoryPanel(String id, Builder<A, E> builder, boolean wizardInModal) {
        super(id, builder, wizardInModal);
        if (SyncopeConsoleSession.get().owns(String.format("%s_CREATE", builder.type), builder.realm) && builder.realm.startsWith("/")) {
            MetaDataRoleAuthorizationStrategy.authorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        } else {
            MetaDataRoleAuthorizationStrategy.unauthorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        }
        if (builder.dynRealm == null) {
            this.setReadOnly(!SyncopeConsoleSession.get().owns(String.format("%s_UPDATE", builder.type), builder.realm));
        } else {
            this.setReadOnly(!SyncopeConsoleSession.get().owns(String.format("%s_UPDATE", builder.type), builder.dynRealm));
        }
        this.realm = builder.realm;
        this.type = builder.type;
        this.fiql = builder.fiql;
        this.utilityModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.utilityModal});
        this.setWindowClosedReloadCallback(this.utilityModal);
        this.modal.size(Modal.Size.Large);
        this.altDefaultModal.size(Modal.Size.Large);
        this.plainSchemas = ((AnyDirectoryPanelBuilder)AnyDirectoryPanelBuilder.class.cast(builder)).getAnyTypeClassTOs().stream().flatMap(anyTypeClassTO -> anyTypeClassTO.getPlainSchemas().stream()).map(schema -> {
            try {
                return (PlainSchemaTO)this.schemaRestClient.read(SchemaType.PLAIN, (String)schema);
            }
            catch (SyncopeClientException e) {
                LOG.warn("Could not read plain schema {}, ignoring", schema, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.derSchemas = ((AnyDirectoryPanelBuilder)AnyDirectoryPanelBuilder.class.cast(builder)).getAnyTypeClassTOs().stream().flatMap(anyTypeClassTO -> anyTypeClassTO.getDerSchemas().stream()).map(schema -> {
            try {
                return (DerSchemaTO)this.schemaRestClient.read(SchemaType.DERIVED, (String)schema);
            }
            catch (SyncopeClientException e) {
                LOG.warn("Could not read derived schema {}, ignoring", schema, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.initResultTable();
        SyncopeWebApplication.get().getAnyDirectoryPanelAdditionalActionsProvider().add(this, this.modal, wizardInModal, this.container, this.type, this.realm, this.fiql, this.rows, this.plainSchemas.stream().map(SchemaTO::getKey).collect(Collectors.toList()), this.derSchemas.stream().map(SchemaTO::getKey).collect(Collectors.toList()), this.pageRef);
    }

    @Override
    protected List<IColumn<A, String>> getColumns() {
        ArrayList<IColumn<A, String>> columns = new ArrayList<IColumn<A, String>>();
        columns.add((IColumn<A, String>)new KeyPropertyColumn((IModel<String>)new ResourceModel("key", "key"), "key"));
        ArrayList prefcolumns = new ArrayList();
        PreferenceManager.getList(DisplayAttributesModalPanel.getPrefDetailView(this.type)).stream().filter(name -> !"key".equalsIgnoreCase((String)name)).forEach(name -> this.addPropertyColumn((String)name, ReflectionUtils.findField(DisplayAttributesModalPanel.getTOClass(this.type), (String)name), prefcolumns));
        PreferenceManager.getList(DisplayAttributesModalPanel.getPrefPlainAttributeView(this.type)).stream().map(a -> this.plainSchemas.stream().filter(p -> p.getKey().equals(a)).findFirst()).flatMap(Optional::stream).forEach(s -> prefcolumns.add((IColumn)new AttrColumn(s.getKey(), s.getLabel(SyncopeConsoleSession.get().getLocale()), SchemaType.PLAIN)));
        PreferenceManager.getList(DisplayAttributesModalPanel.getPrefDerivedAttributeView(this.type)).stream().map(a -> this.derSchemas.stream().filter(p -> p.getKey().equals(a)).findFirst()).flatMap(Optional::stream).forEach(s -> prefcolumns.add((IColumn)new AttrColumn(s.getKey(), s.getLabel(SyncopeConsoleSession.get().getLocale()), SchemaType.DERIVED)));
        if (prefcolumns.isEmpty()) {
            for (String name2 : this.getDefaultAttributeSelection()) {
                this.addPropertyColumn(name2, ReflectionUtils.findField(DisplayAttributesModalPanel.getTOClass(this.type), (String)name2), prefcolumns);
            }
            PreferenceManager.setList(DisplayAttributesModalPanel.getPrefDetailView(this.type), List.of(this.getDefaultAttributeSelection()));
        }
        columns.addAll(prefcolumns);
        return columns;
    }

    protected abstract String[] getDefaultAttributeSelection();

    protected void addPropertyColumn(String name, Field field, List<IColumn<A, String>> columns) {
        if ("key".equalsIgnoreCase(name)) {
            columns.add((IColumn<A, String>)new KeyPropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
        } else if ("token".equalsIgnoreCase(name)) {
            columns.add((IColumn<A, String>)new TokenColumn((IModel<String>)new ResourceModel(name, name), name));
        } else if (field != null && !field.isSynthetic() && (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE))) {
            columns.add((IColumn<A, String>)new BooleanPropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
        } else if (field != null && !field.isSynthetic() && (field.getType().equals(Date.class) || field.getType().equals(OffsetDateTime.class))) {
            columns.add((IColumn<A, String>)new DatePropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
        } else {
            columns.add((IColumn<A, String>)new PropertyColumn((IModel)new ResourceModel(name, name), (Object)name, name));
        }
    }

    @Override
    protected AnyDataProvider<A> dataProvider() {
        return new AnyDataProvider((AbstractAnyRestClient)this.restClient, this.rows, this.filtered, this.realm, this.type, this.pageRef).setFIQL(this.fiql);
    }

    public AnyDataProvider<A> getDataProvider() {
        return (AnyDataProvider)this.dataProvider;
    }

    public void search(String fiql, AjaxRequestTarget target) {
        this.fiql = fiql;
        ((AnyDataProvider)this.dataProvider).setFIQL(fiql);
        super.search(target);
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.DELETE);
        return batches;
    }

    @Override
    protected Panel customResultBody(String panelId, AnyWrapper<A> item, Serializable result) {
        if (!(result instanceof ProvisioningResult)) {
            throw new IllegalStateException("Unsupported result type");
        }
        return new StatusPanel(panelId, (AnyTO)((ProvisioningResult)result).getEntity(), (IModel<List<StatusBean>>)new ListModel(new ArrayList()), ((ProvisioningResult)result).getPropagationStatuses().stream().map(status -> {
            ConnObject before = status.getBeforeObj();
            ConnObjectWrapper afterObjWrapper = new ConnObjectWrapper((AnyTO)((ProvisioningResult)result).getEntity(), status.getResource(), status.getAfterObj());
            return Triple.of((Object)before, (Object)afterObjWrapper, (Object)status.getFailureReason());
        }).collect(Collectors.toList()), this.pageRef);
    }

    public static abstract class Builder<A extends AnyTO, E extends AbstractAnyRestClient<A>>
    extends DirectoryPanel.Builder<A, AnyWrapper<A>, E>
    implements AnyDirectoryPanelBuilder {
        private static final long serialVersionUID = -6828423611982275640L;
        protected String realm = "/";
        protected String dynRealm = null;
        protected final String type;
        private final List<AnyTypeClassTO> anyTypeClassTOs;

        public Builder(List<AnyTypeClassTO> anyTypeClassTOs, E restClient, String type, PageReference pageRef) {
            super(restClient, pageRef);
            this.anyTypeClassTOs = anyTypeClassTOs;
            this.type = type;
        }

        public Builder<A, E> setRealm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder<A, E> setDynRealm(String dynRealm) {
            this.dynRealm = dynRealm;
            return this;
        }

        @Override
        public List<AnyTypeClassTO> getAnyTypeClassTOs() {
            return this.anyTypeClassTOs;
        }
    }

    @FunctionalInterface
    public static interface AnyDirectoryPanelBuilder
    extends Serializable {
        public List<AnyTypeClassTO> getAnyTypeClassTOs();
    }
}

