/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.events.EventCategory;
import org.apache.syncope.client.console.events.EventCategoryPanel;
import org.apache.syncope.client.console.events.SelectedEventsPanel;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Audit
extends BasePage {
    private static final long serialVersionUID = -1100228004207271271L;
    @SpringBean
    protected AuditRestClient auditRestClient;
    protected final IModel<List<EventCategory>> eventCategories = new LoadableDetachableModel<List<EventCategory>>(){
        private static final long serialVersionUID = 4659376149825914247L;

        protected List<EventCategory> load() {
            return Audit.this.auditRestClient.events();
        }
    };

    public Audit(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build("dashboard", "dashboardBr", Dashboard.class)});
        List events = this.auditRestClient.confs().stream().filter(audit -> ((List)this.eventCategories.getObject()).stream().anyMatch(c -> audit.getType() == c.getType() && Objects.equals(audit.getCategory(), c.getCategory()) && Objects.equals(audit.getSubcategory(), c.getSubcategory()))).map(audit -> OpEvent.toString((OpEvent.CategoryType)audit.getType(), (String)audit.getCategory(), (String)audit.getSubcategory(), (String)audit.getOp(), (OpEvent.Outcome)audit.getOutcome())).sorted().collect(Collectors.toList());
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        Form form = new Form("auditForm");
        content.add(new Component[]{form});
        form.add(new Component[]{new EventCategoryPanel("auditPanel", (List)this.eventCategories.getObject(), (IModel)new ListModel(events)){
            private static final long serialVersionUID = 6113164334533550277L;

            @Override
            protected List<String> getListAuthRoles() {
                return List.of("AUDIT_LIST");
            }

            @Override
            protected List<String> getChangeAuthRoles() {
                return List.of("AUDIT_SET");
            }

            @Override
            public void onEventAction(IEvent<?> event) {
                Object object = event.getPayload();
                if (object instanceof SelectedEventsPanel.EventSelectionChanged) {
                    SelectedEventsPanel.EventSelectionChanged eventSelectionChanged = (SelectedEventsPanel.EventSelectionChanged)object;
                    eventSelectionChanged.getToBeRemoved().forEach(Audit.this.auditRestClient::deleteConf);
                    eventSelectionChanged.getToBeAdded().forEach(Audit.this.auditRestClient::enableConf);
                }
            }
        }});
        this.body.add(new Component[]{content});
    }
}

