/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.TargetContext;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class TargetRequest {
    private TargetConfiguration targetConfiguration;
    private Pipe pipe = null;
    private Map<String, TreeSet<String>> headers = new HashMap<String, TreeSet<String>>();
    private URL url;
    private String method;
    private HttpRequest request = null;
    private boolean chunk = true;
    private ProtocolVersion version = null;
    private boolean fullUrl = false;
    private int port = 80;
    private boolean hasEntityBody = true;
    private boolean keepAlive = true;

    public TargetRequest(TargetConfiguration targetConfiguration, URL url, String method, boolean hasEntityBody) {
        this(targetConfiguration, method, url, hasEntityBody);
    }

    public TargetRequest(TargetConfiguration targetConfiguration, String method, URL url, boolean hasEntityBody) {
        this.method = method;
        this.url = url;
        this.targetConfiguration = targetConfiguration;
        this.hasEntityBody = hasEntityBody;
    }

    public void connect(Pipe pipe) {
        this.pipe = pipe;
    }

    public void start(NHttpClientConnection conn) throws IOException, HttpException {
        Map _headers;
        String trpContentType;
        Object o;
        MessageContext requestMsgCtx;
        Long lengthValue;
        if (this.pipe != null) {
            TargetContext.get((NHttpConnection)conn).setWriter(this.pipe);
        }
        String path = this.fullUrl ? this.url.toString() : ("".equals(this.url.getPath()) ? "/" : this.url.getPath()) + (this.url.getQuery() != null ? "?" + this.url.getQuery() : "");
        long contentLength = -1L;
        String contentLengthHeader = null;
        if (this.headers.get("Content-Length") != null && this.headers.get("Content-Length").size() > 0) {
            contentLengthHeader = this.headers.get("Content-Length").first();
        }
        if (contentLengthHeader != null) {
            contentLength = Integer.parseInt(contentLengthHeader);
            this.headers.remove("Content-Length");
        }
        if ((lengthValue = (Long)(requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx()).getProperty("PASS_THROUGH_MESSAGE_LENGTH")) != null) {
            contentLength = lengthValue;
        }
        if (requestMsgCtx.isPropertyTrue("POST_TO_URI")) {
            path = this.url.toString();
        }
        if ((o = requestMsgCtx.getProperty("TRANSPORT_HEADERS")) != null && o instanceof Map && (trpContentType = (String)(_headers = (Map)o).get("Content-Type")) != null && !trpContentType.equals("") && trpContentType.contains("multipart/related") && !requestMsgCtx.isPropertyTrue("message.builder.invoked")) {
            this.addHeader("Content-Type", trpContentType);
        }
        if (this.hasEntityBody) {
            this.request = new BasicHttpEntityEnclosingRequest(this.method, path, (ProtocolVersion)(this.version != null ? this.version : HttpVersion.HTTP_1_1));
            BasicHttpEntity entity = new BasicHttpEntity();
            if (requestMsgCtx.isPropertyTrue("FORCE_HTTP_CONTENT_LENGTH")) {
                entity.setChunked(false);
                if (requestMsgCtx.isPropertyTrue("COPY_CONTENT_LENGTH_FROM_INCOMING") && contentLength > 0L) {
                    entity.setContentLength(contentLength);
                }
            } else if (contentLength != -1L) {
                entity.setChunked(false);
                entity.setContentLength(contentLength);
            } else {
                entity.setChunked(this.chunk);
            }
            ((BasicHttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)entity);
        } else {
            this.request = new BasicHttpRequest(this.method, path, (ProtocolVersion)(this.version != null ? this.version : HttpVersion.HTTP_1_1));
        }
        Set<Map.Entry<String, TreeSet<String>>> entries = this.headers.entrySet();
        for (Map.Entry<String, TreeSet<String>> entry : entries) {
            if (entry.getKey() == null) continue;
            Iterator<String> i = entry.getValue().iterator();
            while (i.hasNext()) {
                this.request.addHeader(entry.getKey(), i.next());
            }
        }
        if (this.request != null) {
            String soapAction = requestMsgCtx.getSoapAction();
            if (soapAction == null) {
                soapAction = requestMsgCtx.getWSAAction();
            }
            if (soapAction == null) {
                requestMsgCtx.getAxisOperation().getInputAction();
            }
            if (requestMsgCtx.isSOAP11() && soapAction != null && soapAction.length() > 0) {
                Header existingHeader = this.request.getFirstHeader("SOAPAction");
                if (existingHeader != null) {
                    this.request.removeHeader(existingHeader);
                }
                MessageFormatter messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(requestMsgCtx);
                this.request.setHeader("SOAPAction", messageFormatter.formatSOAPAction(requestMsgCtx, null, soapAction));
            }
        }
        this.processChunking(conn, requestMsgCtx);
        if (!this.keepAlive) {
            this.request.setHeader("Connection", "Close");
        }
        HttpContext context = conn.getContext();
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.target_host", (Object)new HttpHost(this.url.getHost(), this.port));
        context.setAttribute("http.request", (Object)this.request);
        this.targetConfiguration.getHttpProcessor().process(this.request, context);
        conn.submitRequest(this.request);
        if (this.hasEntityBody) {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_HEAD);
        } else {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
        }
    }

    public void addHeader(String name, String value) {
        if (this.headers.get(name) == null) {
            TreeSet<String> values = new TreeSet<String>();
            values.add(value);
            if ("Content-Type".equalsIgnoreCase(name)) {
                this.headers.put("Content-Type", values);
            } else {
                this.headers.put(name, values);
            }
        } else if ("Content-Type".equalsIgnoreCase(name)) {
            this.headers.remove("Content-Type");
            TreeSet<String> values = new TreeSet<String>();
            values.add(value);
            this.headers.put("Content-Type", values);
        } else {
            TreeSet<String> values = this.headers.get(name);
            values.add(value);
        }
    }

    private void processChunking(NHttpClientConnection conn, MessageContext requestMsgCtx) throws IOException {
        String disableChunking = (String)requestMsgCtx.getProperty("DISABLE_CHUNKING");
        String forceHttp10 = (String)requestMsgCtx.getProperty("FORCE_HTTP_1.0");
        if (("true".equals(disableChunking) || "true".equals(forceHttp10)) && requestMsgCtx.getEnvelope().getBody().getFirstElement() == null) {
            BasicHttpEntity entity = (BasicHttpEntity)((BasicHttpEntityEnclosingRequest)this.request).getEntity();
            try {
                RelayUtils.buildMessage(requestMsgCtx);
                this.hasEntityBody = true;
                Pipe pipe = (Pipe)requestMsgCtx.getProperty("pass-through.pipe");
                if (pipe != null) {
                    pipe.attachConsumer((IOControl)conn);
                    this.connect(pipe);
                    if (Boolean.TRUE.equals(requestMsgCtx.getProperty("message.builder.invoked"))) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        MessageFormatter formatter = MessageProcessorSelector.getMessageFormatter((MessageContext)requestMsgCtx);
                        OMOutputFormat format = PassThroughTransportUtils.getOMOutputFormat(requestMsgCtx);
                        formatter.writeTo(requestMsgCtx, format, (OutputStream)out, false);
                        OutputStream _out = pipe.getOutputStream();
                        IOUtils.write((byte[])out.toByteArray(), (OutputStream)_out);
                        entity.setContentLength((long)out.toByteArray().length);
                        entity.setChunked(false);
                    }
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    public int write(NHttpClientConnection conn, ContentEncoder encoder) throws IOException {
        int bytes = 0;
        if (this.pipe != null) {
            bytes = this.pipe.consume(encoder);
        }
        if (encoder.isCompleted()) {
            this.targetConfiguration.getMetrics().notifySentMessageSize(conn.getMetrics().getSentBytesCount());
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_DONE);
        }
        return bytes;
    }

    public boolean hasEntityBody() {
        return this.hasEntityBody;
    }

    public String getMethod() {
        return this.method;
    }

    public void setChunk(boolean chunk) {
        this.chunk = chunk;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setFullUrl(boolean fullUrl) {
        this.fullUrl = fullUrl;
    }

    public void setVersion(ProtocolVersion version) {
        this.version = version;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public HttpRequest getRequest() {
        return this.request;
    }
}

