/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class SourceResponse {
    private Pipe pipe = null;
    private Map<String, TreeSet<String>> headers = new HashMap<String, TreeSet<String>>();
    private int status = 200;
    private String statusLine = null;
    private HttpResponse response = null;
    private SourceConfiguration sourceConfiguration;
    private ProtocolVersion version = HttpVersion.HTTP_1_1;
    private SourceRequest request = null;
    private boolean versionChangeRequired = false;

    public SourceResponse(SourceConfiguration config, int status, SourceRequest request) {
        this(config, status, null, request);
    }

    public SourceResponse(SourceConfiguration config, int status, String statusLine, SourceRequest request) {
        this.status = status;
        this.statusLine = statusLine;
        this.sourceConfiguration = config;
        this.request = request;
    }

    public void connect(Pipe pipe) {
        this.pipe = pipe;
        if (this.request != null && pipe != null) {
            SourceContext.get((NHttpConnection)this.request.getConnection()).setWriter(pipe);
        }
    }

    public void start(NHttpServerConnection conn) throws IOException, HttpException {
        this.response = this.sourceConfiguration.getResponseFactory().newHttpResponse(this.request.getVersion(), 200, this.request.getConnection().getContext());
        if (this.versionChangeRequired) {
            this.response.setStatusLine(this.version, this.status);
        } else if (this.statusLine != null) {
            this.response.setStatusLine(this.version, this.status, this.statusLine);
        } else {
            this.response.setStatusCode(this.status);
        }
        BasicHttpEntity entity = new BasicHttpEntity();
        int contentLength = -1;
        String contentLengthHeader = null;
        if (this.headers.get("Content-Length") != null && this.headers.get("Content-Length").size() > 0) {
            contentLengthHeader = this.headers.get("Content-Length").first();
        }
        if (contentLengthHeader != null) {
            contentLength = Integer.parseInt(contentLengthHeader);
            this.headers.remove("Content-Length");
        }
        if (contentLength != -1) {
            entity.setChunked(false);
            entity.setContentLength((long)contentLength);
        } else {
            entity.setChunked(true);
        }
        this.response.setEntity((HttpEntity)entity);
        Set<Map.Entry<String, TreeSet<String>>> entries = this.headers.entrySet();
        for (Map.Entry<String, TreeSet<String>> entry : entries) {
            if (entry.getKey() == null) continue;
            Iterator<String> i = entry.getValue().iterator();
            while (i.hasNext()) {
                this.response.addHeader(entry.getKey(), i.next());
            }
        }
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_HEAD);
        HttpContext context = conn.getContext();
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.response", (Object)this.response);
        context.setAttribute("http.request", (Object)SourceContext.getRequest((NHttpConnection)conn).getRequest());
        this.sourceConfiguration.getHttpProcessor().process(this.response, context);
        conn.submitResponse(this.response);
    }

    public int write(NHttpServerConnection conn, ContentEncoder encoder) throws IOException {
        int bytes = 0;
        if (this.pipe != null) {
            bytes = this.pipe.consume(encoder);
        } else {
            encoder.complete();
        }
        if (encoder.isCompleted()) {
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_DONE);
            this.sourceConfiguration.getMetrics().notifySentMessageSize(conn.getMetrics().getSentBytesCount());
            PassThroughTransportUtils.finishUsingSourceConnection(this.response, conn, this.sourceConfiguration.getSourceConnections());
        }
        return bytes;
    }

    public void addHeader(String name, String value) {
        if (this.headers.get(name) == null) {
            TreeSet<String> values = new TreeSet<String>();
            values.add(value);
            this.headers.put(name, values);
        } else {
            TreeSet<String> values = this.headers.get(name);
            values.add(value);
        }
    }

    public void processChunkingOptions(MessageContext responseMsgContext) throws IOException {
        Boolean noEntityBody;
        boolean forceHttp10 = responseMsgContext.isPropertyTrue("FORCE_HTTP_1.0", false);
        boolean disableChunking = responseMsgContext.isPropertyTrue("DISABLE_CHUNKING", false);
        if (!forceHttp10 && !disableChunking) {
            return;
        }
        if (!responseMsgContext.isPropertyTrue("message.builder.invoked", false)) {
            try {
                RelayUtils.buildMessage(responseMsgContext, false);
                responseMsgContext.getEnvelope().buildWithAttachments();
            }
            catch (Exception e) {
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
        }
        if (forceHttp10) {
            this.version = HttpVersion.HTTP_1_0;
            this.versionChangeRequired = true;
        }
        if (Boolean.TRUE.equals(noEntityBody = (Boolean)responseMsgContext.getProperty("NO_ENTITY_BODY"))) {
            this.headers.remove("Content-Type");
            return;
        }
        TreeSet<String> contentLength = new TreeSet<String>();
        contentLength.add(Long.toString(this.getStreamLength(responseMsgContext)));
        this.headers.put("Content-Length", contentLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getStreamLength(MessageContext msgContext) throws IOException {
        CountingOutputStream counter = new CountingOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        try {
            MessageProcessorSelector.getMessageFormatter((MessageContext)msgContext).writeTo(msgContext, PassThroughTransportUtils.getOMOutputFormat(msgContext), (OutputStream)counter, true);
        }
        finally {
            counter.close();
        }
        return counter.getCount();
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

