/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.base.endpoint.URLEndpoint;
import org.apache.axis2.transport.base.endpoint.URLEndpointsConfiguration;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.nhttp.HttpCoreRequestResponseTransport;
import org.apache.synapse.transport.nhttp.HttpGetRequestProcessor;
import org.apache.synapse.transport.nhttp.ListenerContext;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.ServerHandler;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;
import org.apache.synapse.transport.nhttp.util.RESTUtil;

public class ServerWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ServerWorker.class);
    private MessageContext msgContext = null;
    private ConfigurationContext cfgCtx = null;
    private ServerHandler serverHandler = null;
    private NHttpServerConnection conn = null;
    private boolean isHttps = false;
    private HttpRequest request = null;
    private HttpResponse response = null;
    private InputStream is = null;
    private OutputStream os = null;
    private MetricsCollector metrics = null;
    private boolean isRestDispatching = true;
    private HttpGetRequestProcessor httpGetRequestProcessor = null;
    private URLEndpointsConfiguration endpointsConfiguration = null;
    private static final String SOAPACTION = "SOAPAction";
    private static final String LOCATION = "Location";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_HTML = "text/html";
    private static final String TEXT_XML = "text/xml";
    private String remoteAddress = null;

    public ServerWorker(ListenerContext listenerContext, NHttpServerConnection conn, ServerHandler serverHandler, HttpRequest request, InputStream is, HttpResponse response, OutputStream os) {
        this.cfgCtx = listenerContext.getCfgCtx();
        this.conn = conn;
        this.isHttps = listenerContext.isSsl();
        this.metrics = listenerContext.getMetrics();
        this.serverHandler = serverHandler;
        this.request = request;
        this.response = response;
        this.is = is;
        this.os = os;
        this.msgContext = this.createMessageContext(request);
        this.isRestDispatching = listenerContext.isRestDispatching();
        this.httpGetRequestProcessor = listenerContext.getHttpGetRequestProcessor();
        this.endpointsConfiguration = listenerContext.getEndpoints();
    }

    private MessageContext createMessageContext(HttpRequest request) {
        HttpInetConnection inetConn;
        InetAddress remoteAddr;
        MessageContext msgContext = new MessageContext();
        msgContext.setMessageID(UIDGenerator.generateURNString());
        msgContext.setProperty("ClientApiNonBlocking", (Object)Boolean.FALSE);
        msgContext.setConfigurationContext(this.cfgCtx);
        if (this.isHttps) {
            msgContext.setTransportOut(this.cfgCtx.getAxisConfiguration().getTransportOut("https"));
            msgContext.setTransportIn(this.cfgCtx.getAxisConfiguration().getTransportIn("https"));
            msgContext.setIncomingTransportName("https");
        } else {
            msgContext.setTransportOut(this.cfgCtx.getAxisConfiguration().getTransportOut("http"));
            msgContext.setTransportIn(this.cfgCtx.getAxisConfiguration().getTransportIn("http"));
            msgContext.setIncomingTransportName("http");
        }
        msgContext.setProperty("OutTransportInfo", (Object)this);
        msgContext.setServerSide(true);
        msgContext.setProperty("TransportInURL", (Object)request.getRequestLine().getUri());
        TreeMap<String, String> headers = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (Header header : request.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        msgContext.setProperty("TRANSPORT_HEADERS", headers);
        if (this.conn instanceof HttpInetConnection && (remoteAddr = (inetConn = (HttpInetConnection)this.conn).getRemoteAddress()) != null) {
            msgContext.setProperty("REMOTE_ADDR", (Object)remoteAddr.getHostAddress());
            msgContext.setProperty("REMOTE_HOST", (Object)NhttpUtil.getHostName(remoteAddr));
            this.remoteAddress = remoteAddr.getHostAddress();
        }
        msgContext.setProperty("RequestResponseTransportControl", (Object)new HttpCoreRequestResponseTransport(msgContext));
        msgContext.setProperty("synapse.server-connection-debug", this.conn.getContext().getAttribute("synapse.server-connection-debug"));
        msgContext.setProperty("nhttp.input.stream", (Object)this.is);
        msgContext.setProperty("nhttp.output.stream", (Object)this.os);
        return msgContext;
    }

    @Override
    public void run() {
        HttpInetConnection inetConn;
        InetAddress localAddr;
        Header hostHeader;
        String host;
        int pos;
        String uri;
        String method = this.request.getRequestLine().getMethod().toUpperCase();
        this.msgContext.setProperty("HTTP_METHOD", (Object)this.request.getRequestLine().getMethod());
        if (NHttpConfiguration.getInstance().isHttpMethodDisabled(method)) {
            this.handleException("Unsupported method : " + method, null);
        }
        String oriUri = uri = this.request.getRequestLine().getUri();
        if (uri.indexOf(this.cfgCtx.getServicePath()) != -1) {
            pos = (uri = uri.substring(uri.indexOf(this.cfgCtx.getServicePath()) + this.cfgCtx.getServicePath().length())).indexOf("/", 1);
            uri = pos > 0 ? uri.substring(pos) : ((pos = uri.indexOf("?")) != -1 ? uri.substring(pos) : "");
        } else {
            pos = uri.indexOf("://");
            if (pos != -1) {
                uri = uri.substring(pos + 3);
            }
            if ((pos = uri.indexOf("/")) != -1) {
                uri = uri.substring(pos + 1);
            }
        }
        this.msgContext.setProperty("REST_URL_POSTFIX", (Object)uri);
        String servicePrefix = oriUri.substring(0, oriUri.indexOf(uri));
        if (servicePrefix.indexOf("://") == -1 && (host = (hostHeader = this.request.getFirstHeader("Host")) != null ? hostHeader.getValue() : ((localAddr = (inetConn = (HttpInetConnection)this.conn).getLocalAddress()) != null ? localAddr.getHostName() + ":" + inetConn.getLocalPort() : null)) != null) {
            servicePrefix = (this.isHttps ? "https://" : "http://") + host + servicePrefix;
        }
        this.msgContext.setProperty("SERVICE_PREFIX", (Object)servicePrefix);
        if ("GET".equals(method)) {
            this.httpGetRequestProcessor.process(this.request, this.response, this.msgContext, this.conn, this.os, this.isRestDispatching);
        } else if ("POST".equals(method)) {
            this.processEntityEnclosingMethod();
        } else if ("PUT".equals(method)) {
            this.processEntityEnclosingMethod();
        } else if ("HEAD".equals(method)) {
            this.processNonEntityEnclosingMethod();
        } else if ("OPTIONS".equals(method)) {
            this.processNonEntityEnclosingMethod();
        } else if ("DELETE".equals(method)) {
            this.processGetAndDelete("DELETE");
        } else if ("TRACE".equals(method)) {
            this.processNonEntityEnclosingMethod();
        } else {
            this.handleException("Unsupported method : " + method, null);
        }
        if (this.isAckRequired()) {
            String respWritten = "";
            if (this.msgContext.getOperationContext() != null) {
                respWritten = (String)this.msgContext.getOperationContext().getProperty("RESPONSE_WRITTEN");
            }
            boolean respWillFollow = !"true".equals(respWritten) && !"SKIP".equals(respWritten);
            boolean acked = ((RequestResponseTransport)this.msgContext.getProperty("RequestResponseTransportControl")).getStatus() == RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            boolean forced = this.msgContext.isPropertyTrue("FORCE_SC_ACCEPTED");
            boolean nioAck = this.msgContext.isPropertyTrue("NIO-ACK-Requested", false);
            if (respWillFollow || acked || forced || nioAck) {
                if (!nioAck) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sending 202 Accepted response for MessageID : " + this.msgContext.getMessageID() + " response written : " + respWritten + " response will follow : " + respWillFollow + " acked : " + acked + " forced ack : " + forced));
                    }
                    this.response.setStatusCode(202);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sending ACK response with status " + this.msgContext.getProperty("HTTP_SC") + ", for MessageID : " + this.msgContext.getMessageID()));
                    }
                    this.response.setStatusCode(Integer.parseInt(this.msgContext.getProperty("HTTP_SC").toString()));
                    Map responseHeaders = (Map)this.msgContext.getProperty("TRANSPORT_HEADERS");
                    if (responseHeaders != null) {
                        for (Map.Entry entry : responseHeaders.entrySet()) {
                            this.response.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                if (this.metrics != null) {
                    this.metrics.incrementMessagesSent();
                }
                try {
                    this.serverHandler.commitResponse(this.conn, this.response);
                }
                catch (HttpException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    this.handleException("Unexpected HTTP protocol error : " + e.getMessage(), (Exception)((Object)e));
                }
                catch (ConnectionClosedException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    log.warn((Object)"Connection closed by client (Connection closed)");
                }
                catch (IllegalStateException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    log.warn((Object)"Connection closed by client (Buffer closed)");
                }
                catch (IOException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    this.handleException("IO Error sending response message", e);
                }
                catch (Exception e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    this.handleException("General Error sending response message", e);
                }
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                try {
                    this.os.flush();
                    this.os.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isAckRequired() {
        if (this.msgContext != null) {
            if (this.msgContext.getOperationContext() != null && (!this.msgContext.getOperationContext().getAxisOperation().isControlOperation() || this.msgContext.isPropertyTrue("FORCE_SC_ACCEPTED"))) {
                return true;
            }
            if (this.msgContext.isPropertyTrue("NIO-ACK-Requested", false)) {
                return true;
            }
        }
        return false;
    }

    private void processEntityEnclosingMethod() {
        try {
            URLEndpoint epr;
            Header contentType = this.request.getFirstHeader(CONTENT_TYPE);
            String contentTypeStr = contentType != null ? contentType.getValue() : this.inferContentType();
            String charSetEncoding = BuilderUtil.getCharSetEncoding((String)contentTypeStr);
            this.msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEncoding);
            boolean eprFound = false;
            if (this.endpointsConfiguration != null && (epr = this.endpointsConfiguration.getEndpoint(this.request.getRequestLine().getUri())) != null) {
                eprFound = true;
                String type = TransportUtils.getContentType((String)contentTypeStr, (MessageContext)this.msgContext);
                this.msgContext.setProperty("messageType", (Object)type);
                epr.setParameters(this.msgContext);
                Builder builder = epr.getBuilder(type);
                if (HTTPTransportUtils.isRESTRequest((String)contentTypeStr)) {
                    RESTUtil.processPOSTRequest(this.msgContext, this.is, this.os, this.request.getRequestLine().getUri(), contentType, builder, this.isRestDispatching);
                } else {
                    Header soapAction = this.request.getFirstHeader(SOAPACTION);
                    HTTPTransportUtils.processHTTPPostRequest((MessageContext)this.msgContext, (InputStream)this.is, (OutputStream)this.os, (String)contentTypeStr, (Builder)builder, (String)(soapAction != null ? soapAction.getValue() : null), (String)this.request.getRequestLine().getUri());
                }
            }
            if (!eprFound) {
                if (HTTPTransportUtils.isRESTRequest((String)contentTypeStr)) {
                    RESTUtil.processPOSTRequest(this.msgContext, this.is, this.os, this.request.getRequestLine().getUri(), contentType, this.isRestDispatching);
                } else {
                    Header soapAction = this.request.getFirstHeader(SOAPACTION);
                    HTTPTransportUtils.processHTTPPostRequest((MessageContext)this.msgContext, (InputStream)this.is, (OutputStream)this.os, (String)contentTypeStr, (String)(soapAction != null ? soapAction.getValue() : null), (String)this.request.getRequestLine().getUri());
                }
            }
        }
        catch (AxisFault e) {
            this.handleException("Error processing POST request ", (Exception)((Object)e));
        }
    }

    private String inferContentType() {
        Parameter param = this.cfgCtx.getAxisConfiguration().getParameter("DEFAULT_REQUEST_CONTENT_TYPE");
        if (param != null) {
            return param.getValue().toString();
        }
        return null;
    }

    private void processNonEntityEnclosingMethod() {
        try {
            RESTUtil.processURLRequest(this.msgContext, this.os, null, this.request.getRequestLine().getUri());
        }
        catch (AxisFault e) {
            this.handleException("Error processing " + this.request.getRequestLine().getMethod() + " request for : " + this.request.getRequestLine().getUri(), (Exception)((Object)e));
        }
    }

    private void processGetAndDelete(String method) {
        try {
            URLEndpoint epr;
            Header contentType = this.request.getFirstHeader(CONTENT_TYPE);
            String contentTypeStr = contentType != null ? contentType.getValue() : this.inferContentType();
            boolean eprFound = false;
            if (this.endpointsConfiguration != null && (epr = this.endpointsConfiguration.getEndpoint(this.request.getRequestLine().getUri())) != null) {
                eprFound = true;
                String type = TransportUtils.getContentType((String)contentTypeStr, (MessageContext)this.msgContext);
                this.msgContext.setProperty("messageType", (Object)type);
                epr.setParameters(this.msgContext);
                Builder builder = epr.getBuilder(type);
                RESTUtil.processGetAndDeleteRequest(this.msgContext, this.os, this.request.getRequestLine().getUri(), this.request.getFirstHeader(CONTENT_TYPE), builder, method, this.isRestDispatching);
            }
            if (!eprFound) {
                RESTUtil.processGetAndDeleteRequest(this.msgContext, this.os, this.request.getRequestLine().getUri(), this.request.getFirstHeader(CONTENT_TYPE), method, this.isRestDispatching);
            }
        }
        catch (AxisFault axisFault) {
            this.handleException("Error processing " + method + " request for: " + this.request.getRequestLine().getUri(), (Exception)((Object)axisFault));
        }
    }

    private void handleException(String msg, Exception e) {
        if (e == null) {
            log.error((Object)msg);
        } else {
            log.error((Object)msg, (Throwable)e);
        }
        Exception newException = e;
        if (e == null) {
            newException = new Exception(msg);
        }
        try {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)this.msgContext, (Throwable)newException);
            AxisEngine.sendFault((MessageContext)faultContext);
        }
        catch (Exception ex) {
            this.response.setStatusCode(500);
            this.response.addHeader(CONTENT_TYPE, TEXT_XML);
            this.conn.getContext().setAttribute("FORCE_CONNECTION_CLOSE", (Object)true);
            this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
            try {
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                String body = "<html><body><h1>Failed to process the request</h1><p>" + msg + "</p>";
                if (e != null) {
                    body = body + "<p>" + e.getMessage() + "</p></body></html>";
                }
                if (ex != null) {
                    body = body + "<p>" + ex.getMessage() + "</p></body></html>";
                }
                this.os.write(body.getBytes());
                this.os.flush();
                this.os.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public InputStream getIs() {
        return this.is;
    }

    public ServerHandler getServiceHandler() {
        return this.serverHandler;
    }

    public NHttpServerConnection getConn() {
        return this.conn;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }
}

