/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.synapse.transport.nhttp.HostnameVerifier;
import org.apache.synapse.transport.nhttp.HttpCoreNIOSender;
import org.apache.synapse.transport.nhttp.NoValidateCertTrustManager;
import org.apache.synapse.transport.utils.conn.logging.LoggingUtils;
import org.apache.synapse.transport.utils.sslcert.CertificateVerificationConfig;
import org.apache.synapse.transport.utils.sslcert.CertificateVerificationException;
import org.apache.synapse.transport.utils.sslcert.adaptor.SynapseAdaptorForOcspCrl;

public class HttpCoreNIOSSLSender
extends HttpCoreNIOSender {
    private static final Log log = LogFactory.getLog(HttpCoreNIOSSLSender.class);
    private static final SynapseAdaptorForOcspCrl ocspCrl = new SynapseAdaptorForOcspCrl();

    @Override
    protected IOEventDispatch getEventDispatch(NHttpClientEventHandler handler, SSLContext sslContext, SSLSetupHandler sslSetupHandler, ConnectionConfig config, TransportOutDescription transportOut) throws AxisFault {
        return LoggingUtils.getClientIODispatch(handler, config, sslContext, sslSetupHandler, this.getCustomSSLContexts(transportOut));
    }

    @Override
    protected SSLContext getSSLContext(TransportOutDescription transportOut) throws AxisFault {
        Parameter keyParam = transportOut.getParameter("keystore");
        Parameter trustParam = transportOut.getParameter("truststore");
        OMElement ksEle = null;
        OMElement tsEle = null;
        if (keyParam != null) {
            ksEle = keyParam.getParameterElement().getFirstElement();
        }
        boolean novalidatecert = ParamUtils.getOptionalParamBoolean((ParameterInclude)transportOut, (String)"novalidatecert", (boolean)false);
        if (trustParam != null) {
            if (novalidatecert) {
                log.warn((Object)"Ignoring novalidatecert parameter since a truststore has been specified");
            }
            tsEle = trustParam.getParameterElement().getFirstElement();
        }
        return this.createSSLContext(ksEle, tsEle, novalidatecert);
    }

    @Override
    protected SSLSetupHandler getSSLSetupHandler(TransportOutDescription transportOut) throws AxisFault {
        Parameter hostnameVerifier = transportOut.getParameter("HostnameVerifier");
        String hostnameVerifierValue = hostnameVerifier != null ? hostnameVerifier.getValue().toString() : null;
        Parameter revocationVerifierParam = transportOut.getParameter("CertificateRevocationVerifier");
        CertificateVerificationConfig cvConfig = revocationVerifierParam != null ? new CertificateVerificationConfig(revocationVerifierParam) : null;
        return this.createSSLSetupHandler(hostnameVerifierValue, cvConfig);
    }

    private Map<String, SSLContext> getCustomSSLContexts(TransportOutDescription transportOut) throws AxisFault {
        Parameter customProfilesParam;
        if (log.isDebugEnabled()) {
            log.info((Object)"Loading custom SSL profiles for the HTTPS sender");
        }
        if ((customProfilesParam = transportOut.getParameter("customSSLProfiles")) == null) {
            return null;
        }
        OMElement customProfilesElt = customProfilesParam.getParameterElement();
        Iterator profiles = customProfilesElt.getChildrenWithName(new QName("profile"));
        HashMap<String, SSLContext> contextMap = new HashMap<String, SSLContext>();
        while (profiles.hasNext()) {
            OMElement profile = (OMElement)profiles.next();
            OMElement serversElt = profile.getFirstChildWithName(new QName("servers"));
            if (serversElt == null || serversElt.getText() == null) {
                String msg = "Each custom SSL profile must define at least one host:port pair under the servers element";
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            String[] servers = serversElt.getText().split(",");
            OMElement ksElt = profile.getFirstChildWithName(new QName("KeyStore"));
            OMElement trElt = profile.getFirstChildWithName(new QName("TrustStore"));
            String noValCert = profile.getAttributeValue(new QName("novalidatecert"));
            boolean novalidatecert = "true".equals(noValCert);
            SSLContext sslContext = this.createSSLContext(ksElt, trElt, novalidatecert);
            for (String server : servers) {
                if (!contextMap.containsKey(server = server.trim())) {
                    contextMap.put(server, sslContext);
                    continue;
                }
                log.warn((Object)("Multiple SSL profiles were found for the server : " + server + ". " + "Ignoring the excessive profiles."));
            }
        }
        if (contextMap.size() > 0) {
            log.info((Object)("Custom SSL profiles initialized for " + contextMap.size() + " servers"));
            return contextMap;
        }
        return null;
    }

    private SSLContext createSSLContext(OMElement keyStoreElt, OMElement trustStoreElt, boolean novalidatecert) throws AxisFault {
        String storePassword;
        String type;
        String location;
        KeyManager[] keymanagers = null;
        TrustManager[] trustManagers = null;
        if (keyStoreElt != null) {
            location = keyStoreElt.getFirstChildWithName(new QName("Location")).getText();
            type = keyStoreElt.getFirstChildWithName(new QName("Type")).getText();
            storePassword = keyStoreElt.getFirstChildWithName(new QName("Password")).getText();
            String keyPassword = keyStoreElt.getFirstChildWithName(new QName("KeyPassword")).getText();
            FileInputStream fis = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(type);
                fis = new FileInputStream(location);
                log.info((Object)("Loading Identity Keystore from : " + location));
                keyStore.load(fis, storePassword.toCharArray());
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(keyStore, keyPassword.toCharArray());
                keymanagers = kmfactory.getKeyManagers();
            }
            catch (GeneralSecurityException gse) {
                log.error((Object)("Error loading Keystore : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Keystore : " + location, (Throwable)gse);
            }
            catch (IOException ioe) {
                log.error((Object)("Error opening Keystore : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Keystore : " + location, (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        if (trustStoreElt != null) {
            if (novalidatecert) {
                log.warn((Object)"Ignoring novalidatecert parameter since a truststore has been specified");
            }
            location = trustStoreElt.getFirstChildWithName(new QName("Location")).getText();
            type = trustStoreElt.getFirstChildWithName(new QName("Type")).getText();
            storePassword = trustStoreElt.getFirstChildWithName(new QName("Password")).getText();
            FileInputStream fis = null;
            try {
                KeyStore trustStore = KeyStore.getInstance(type);
                fis = new FileInputStream(location);
                log.info((Object)("Loading Trust Keystore from : " + location));
                trustStore.load(fis, storePassword.toCharArray());
                TrustManagerFactory trustManagerfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerfactory.init(trustStore);
                trustManagers = trustManagerfactory.getTrustManagers();
            }
            catch (GeneralSecurityException gse) {
                log.error((Object)("Error loading Key store : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Key store : " + location, (Throwable)gse);
            }
            catch (IOException ioe) {
                log.error((Object)("Error opening Key store : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Key store : " + location, (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        if (novalidatecert) {
            log.warn((Object)"Server certificate validation (trust) has been disabled. DO NOT USE IN PRODUCTION!");
            trustManagers = new TrustManager[]{new NoValidateCertTrustManager()};
        }
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(keymanagers, trustManagers, null);
            return sslcontext;
        }
        catch (GeneralSecurityException gse) {
            log.error((Object)"Unable to create SSL context with the given configuration", (Throwable)gse);
            throw new AxisFault("Unable to create SSL context with the given configuration", (Throwable)gse);
        }
    }

    private SSLSetupHandler createSSLSetupHandler(final String hostnameVerifier, final CertificateVerificationConfig cvConfig) throws AxisFault {
        return new SSLSetupHandler(){

            public void initalize(SSLEngine sslengine) {
            }

            public void verify(IOSession ioSession, SSLSession session) throws SSLException {
                SocketAddress remoteAddress = ioSession.getRemoteAddress();
                String address = remoteAddress instanceof InetSocketAddress ? ((InetSocketAddress)remoteAddress).getHostName() : remoteAddress.toString();
                boolean valid = false;
                if (hostnameVerifier != null) {
                    if ("Strict".equals(hostnameVerifier)) {
                        valid = HostnameVerifier.STRICT.verify(address, session);
                    } else if ("AllowAll".equals(hostnameVerifier)) {
                        valid = HostnameVerifier.ALLOW_ALL.verify(address, session);
                    } else if ("DefaultAndLocalhost".equals(hostnameVerifier)) {
                        valid = HostnameVerifier.DEFAULT_AND_LOCALHOST.verify(address, session);
                    }
                } else {
                    valid = HostnameVerifier.DEFAULT.verify(address, session);
                }
                if (!valid) {
                    throw new SSLException("Host name verification failed for host : " + address);
                }
                if (cvConfig != null) {
                    try {
                        ocspCrl.verifyRevocationStatus(session.getPeerCertificateChain(), cvConfig.getCacheSize(), cvConfig.getCacheDuration());
                    }
                    catch (CertificateVerificationException e) {
                        throw new SSLException("Certificate chain validation failed for host : " + address, e);
                    }
                }
            }
        };
    }
}

