/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.util.MiscellaneousUtil;

public final class NHttpConfiguration {
    private static final int WORKERS_CORE_THREADS = 20;
    private static final int WORKERS_MAX_THREADS = 100;
    private static final int WORKER_KEEP_ALIVE = 5;
    private static final int BLOCKING_QUEUE_LENGTH = -1;
    private static final int IO_WORKER_COUNT = 2;
    private static final int BUFFER_SIZE = 8192;
    private static final String S_T_CORE = "snd_t_core";
    private static final String S_T_MAX = "snd_t_max";
    private static final String S_T_ALIVE = "snd_alive_sec";
    private static final String S_T_QLEN = "snd_qlen";
    private static final String S_IO_WORKERS = "snd_io_threads";
    private static final String C_T_CORE = "lst_t_core";
    private static final String C_T_MAX = "lst_t_max";
    private static final String C_T_ALIVE = "lst_alive_sec";
    private static final String C_T_QLEN = "lst_qlen";
    private static final String C_IO_WORKERS = "lst_io_threads";
    private static final String G_BUFFER_SIZE = "nhttp_buffer_size";
    private static final String G_DISABLED_HTTP_METHODS = "nhttp_disabled_methods";
    private static final Log log = LogFactory.getLog(NHttpConfiguration.class);
    private static NHttpConfiguration _instance = new NHttpConfiguration();
    private Properties props;
    List<String> methods;
    public static final String BLOCK_SERVICE_LIST = "http.block_service_list";
    public static final String BLOCK_SERVICE_LIST_DEFAULT = "false";

    private NHttpConfiguration() {
        try {
            this.props = MiscellaneousUtil.loadProperties((String)"nhttp.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static NHttpConfiguration getInstance() {
        return _instance;
    }

    public int getServerCoreThreads() {
        return this.getProperty(S_T_CORE, 20);
    }

    public int getServerMaxThreads() {
        return this.getProperty(S_T_MAX, 100);
    }

    public int getServerKeepalive() {
        return this.getProperty(S_T_ALIVE, 5);
    }

    public int getServerQueueLen() {
        return this.getProperty(S_T_QLEN, -1);
    }

    public int getServerIOWorkers() {
        return this.getProperty(S_IO_WORKERS, 2);
    }

    public int getClientCoreThreads() {
        return this.getProperty(C_T_CORE, 20);
    }

    public int getClientMaxThreads() {
        return this.getProperty(C_T_MAX, 100);
    }

    public int getClientKeepalive() {
        return this.getProperty(C_T_ALIVE, 5);
    }

    public int getClientQueueLen() {
        return this.getProperty(C_T_QLEN, -1);
    }

    public int getClientIOWorkers() {
        return this.getProperty(C_IO_WORKERS, 2);
    }

    public int getBufferSize() {
        return this.getProperty(G_BUFFER_SIZE, 8192);
    }

    public boolean isKeepAliveDisabled() {
        return this.getProperty("http.connection.disable.keepalive", 0) == 1;
    }

    public boolean isPreserveUserAgentHeader() {
        return this.getBooleanValue("http.user.agent.preserve", false);
    }

    public boolean isPreserveServerHeader() {
        return this.getBooleanValue("http.server.preserve", true);
    }

    public boolean isCountConnections() {
        return this.getBooleanValue("http.count.connections", false);
    }

    public String isServiceListBlocked() {
        return this.getStringValue(BLOCK_SERVICE_LIST, BLOCK_SERVICE_LIST_DEFAULT);
    }

    public int getProperty(String name, int def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null && Integer.valueOf(val) > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using nhttp tuning parameter : " + name + " = " + val));
            }
            return Integer.valueOf(val);
        }
        return def;
    }

    public boolean getBooleanValue(String name, boolean def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null && Boolean.parseBoolean(val)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using nhttp tuning parameter : " + name));
            }
            return true;
        }
        if (val != null && !Boolean.parseBoolean(val)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using nhttp tuning parameter : " + name));
            }
            return false;
        }
        return def;
    }

    public String getStringValue(String name, String def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        return val == null ? def : val;
    }

    public boolean isHttpMethodDisabled(String method) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
            String methodsString = this.getStringValue(G_DISABLED_HTTP_METHODS, "");
            for (String methodStr : methodsString.split(",")) {
                this.methods.add(methodStr.trim().toUpperCase());
            }
        }
        return this.methods.contains(method);
    }
}

