/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.utils;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    static Logger LOG = LoggerFactory.getLogger(NetworkUtils.class);

    public static int findRandomAvailablePortOnAllLocalInterfaces() throws IOException {
        int port;
        try (ServerSocket socket = new ServerSocket(0);){
            port = socket.getLocalPort();
            socket.close();
        }
        return port;
    }

    public static String findAvailableHostAddress() throws UnknownHostException, SocketException {
        String submarineServerIP = System.getenv("SUBMARINE_LOCAL_IP");
        if (submarineServerIP != null) {
            return submarineServerIP;
        }
        InetAddress address = InetAddress.getLocalHost();
        if (address.isLoopbackAddress()) {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (networkInterface.isLoopback()) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress a = interfaceAddress.getAddress();
                    if (!(a instanceof Inet4Address)) continue;
                    return a.getHostAddress();
                }
            }
        }
        return address.getHostAddress();
    }

    public static boolean checkIfRemoteEndpointAccessible(String host, int port) {
        try {
            Socket discover = new Socket();
            discover.setSoTimeout(1000);
            discover.connect(new InetSocketAddress(host, port), 1000);
            discover.close();
            return true;
        }
        catch (ConnectException cne) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Remote endpoint '" + host + ":" + port + "' is not accessible (might be initializing): " + cne.getMessage());
            }
            return false;
        }
        catch (IOException ioe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Remote endpoint '" + host + ":" + port + "' is not accessible (might be initializing): " + ioe.getMessage());
            }
            return false;
        }
    }

    public static String getInterpreterSettingId(String intpGrpId) {
        String settingId = null;
        if (intpGrpId != null) {
            int indexOfColon = intpGrpId.indexOf("-");
            settingId = intpGrpId.substring(0, indexOfColon);
        }
        return settingId;
    }

    public static boolean isEnvString(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        return key.matches("^[A-Z_0-9]*");
    }
}

