/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.result.xslt;

import jakarta.servlet.ServletContext;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServletURIResolver
implements URIResolver {
    private static final Logger LOG = LogManager.getLogger(ServletURIResolver.class);
    private static final String PROTOCOL = "response:";
    private final ServletContext servletContext;

    public ServletURIResolver(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        LOG.debug("ServletURIResolver resolve(): href={}, base={}", (Object)href, (Object)base);
        if (href.startsWith(PROTOCOL)) {
            String res = href.substring(PROTOCOL.length());
            LOG.debug("Resolving resource <{}>", (Object)res);
            InputStream is = this.servletContext.getResourceAsStream(res);
            if (is == null) {
                throw new TransformerException("Resource " + res + " not found in resources.");
            }
            return new StreamSource(is);
        }
        throw new TransformerException("Cannot handle protocol of resource " + href);
    }
}

