/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.spring;

import com.opensymphony.xwork2.util.classloader.FileResourceStore;
import com.opensymphony.xwork2.util.classloader.JarResourceStore;
import com.opensymphony.xwork2.util.classloader.ReloadingClassLoader;
import com.opensymphony.xwork2.util.classloader.ResourceStore;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.spring.ClassReloadingBeanFactory;
import org.apache.struts2.spring.ClassReloadingInstantiationStrategy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ClassReloadingXMLWebApplicationContext
extends XmlWebApplicationContext
implements FilesystemAlterationListener {
    private static final Logger LOG = LogManager.getLogger(ClassReloadingXMLWebApplicationContext.class);
    protected ReloadingClassLoader classLoader;
    protected FilesystemAlterationMonitor filesystemAlterationMonitor;
    protected ClassReloadingBeanFactory beanFactory;
    private boolean reloadConfig;

    public void setupReloading(String[] watchList, String acceptClasses, ServletContext servletContext, boolean reloadConfig) {
        this.reloadConfig = reloadConfig;
        this.classLoader = new ReloadingClassLoader(ClassReloadingXMLWebApplicationContext.class.getClassLoader());
        if (StringUtils.isNotBlank((CharSequence)acceptClasses)) {
            String[] splitted = acceptClasses.split(",");
            HashSet<Pattern> patterns = new HashSet<Pattern>(splitted.length);
            for (String pattern : splitted) {
                patterns.add(Pattern.compile(pattern));
            }
            this.classLoader.setAccepClasses(patterns);
        }
        this.filesystemAlterationMonitor = new FilesystemAlterationMonitor();
        for (String watch : watchList) {
            File file = new File(watch);
            if (!file.isAbsolute()) {
                file = new File(servletContext.getRealPath(watch));
            }
            if (watch.endsWith(".jar")) {
                this.classLoader.addResourceStore((ResourceStore)new JarResourceStore(file));
                this.filesystemAlterationMonitor.addListener(file, (FilesystemAlterationListener)this);
                LOG.debug("Watching [{}] for changes", (Object)file.getAbsolutePath());
                continue;
            }
            ArrayList<File> dirs = new ArrayList<File>();
            this.getAllPaths(file, dirs);
            this.classLoader.addResourceStore((ResourceStore)new FileResourceStore(file));
            for (File dir : dirs) {
                this.filesystemAlterationMonitor.addListener(dir, (FilesystemAlterationListener)this);
                LOG.debug("Watching [{}] for changes", (Object)dir.getAbsolutePath());
            }
        }
        this.beanFactory = new ClassReloadingBeanFactory();
        this.beanFactory.setInstantiationStrategy((InstantiationStrategy)new ClassReloadingInstantiationStrategy());
        this.beanFactory.setBeanClassLoader((ClassLoader)this.classLoader);
        this.filesystemAlterationMonitor.start();
    }

    private void getAllPaths(File root, List<File> dirs) {
        File[] files;
        dirs.add(root);
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this.getAllPaths(file, dirs);
            }
        }
    }

    public void close() {
        super.close();
        if (this.filesystemAlterationMonitor != null) {
            this.filesystemAlterationMonitor.removeListener((FilesystemAlterationListener)this);
            this.filesystemAlterationMonitor.stop();
        }
    }

    public void refresh() throws BeansException, IllegalStateException {
        if (this.classLoader != null) {
            this.classLoader.reload();
        }
        super.refresh();
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return this.beanFactory != null ? this.beanFactory : super.createBeanFactory();
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        if (this.classLoader != null) {
            beanFactory.setBeanClassLoader((ClassLoader)this.classLoader);
        }
    }

    public void onDirectoryChange(File file) {
        this.reload(file);
    }

    public void onDirectoryCreate(File file) {
        this.reload(file);
    }

    public void onDirectoryDelete(File file) {
    }

    public void onFileChange(File file) {
        this.reload(file);
    }

    public void onFileCreate(File file) {
        this.reload(file);
    }

    private void reload(File file) {
        if (this.classLoader != null) {
            LOG.debug("Change detected in file [{}], reloading class loader", (Object)file.getAbsolutePath());
            this.classLoader.reload();
            if (this.reloadConfig && Dispatcher.getInstance() != null) {
                LOG.debug("Change detected in file [{}], reloading configuration", (Object)file.getAbsolutePath());
                Dispatcher.getInstance().getConfigurationManager().reload();
            }
        }
    }

    public void onFileDelete(File file) {
    }

    public void onStart(FilesystemAlterationObserver filesystemAlterationObserver) {
    }

    public void onStop(FilesystemAlterationObserver filesystemAlterationObserver) {
    }

    public ReloadingClassLoader getReloadingClassLoader() {
        return this.classLoader;
    }
}

