/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.freemarker;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.portlet.PortletConstants;
import org.apache.struts2.portlet.PortletPhase;
import org.apache.struts2.portlet.context.PortletActionContext;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.util.ResourceUtil;

public class PortletFreemarkerResult
extends StrutsResultSupport {
    private static final long serialVersionUID = -5570612389289887543L;
    protected ActionInvocation invocation;
    protected Configuration configuration;
    protected ObjectWrapper wrapper;
    protected FreemarkerManager freemarkerManager;
    protected String location;
    private String pContentType = "text/html";

    public PortletFreemarkerResult() {
    }

    public PortletFreemarkerResult(String location) {
        super(location);
    }

    @Inject
    public void setFreemarkerManager(FreemarkerManager mgr) {
        this.freemarkerManager = mgr;
    }

    public void setContentType(String aContentType) {
        this.pContentType = aContentType;
    }

    public String getContentType() {
        return this.pContentType;
    }

    public void doExecute(String location, ActionInvocation invocation) throws IOException, TemplateException, PortletException {
        PortletPhase phase = PortletActionContext.getPhase();
        if (phase.isAction()) {
            this.executeActionResult(location, invocation);
        } else if (phase.isRender()) {
            this.executeRenderResult(location, invocation);
        } else if (phase.isResource()) {
            this.executeResourceResult(location, invocation);
        }
    }

    private void executeActionResult(String location, ActionInvocation invocation) {
        ActionResponse res = PortletActionContext.getActionResponse();
        invocation.getInvocationContext().getSession().put(PortletConstants.RENDER_DIRECT_LOCATION, location);
        res.setRenderParameter(PortletConstants.ACTION_PARAM, "freemarkerDirect");
        res.setRenderParameter("location", location);
        res.setRenderParameter(PortletConstants.MODE_PARAM, PortletActionContext.getRequest().getPortletMode().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRenderResult(String location, ActionInvocation invocation) throws TemplateException, IOException, PortletException {
        TemplateModel model;
        Template template;
        this.location = location;
        this.invocation = invocation;
        this.configuration = this.getConfiguration();
        this.wrapper = this.getObjectWrapper();
        HttpServletRequest req = ServletActionContext.getRequest();
        if (!location.startsWith("/")) {
            String base = ResourceUtil.getResourceBase((HttpServletRequest)req);
            location = base + "/" + location;
        }
        if (this.preTemplateProcess(template = this.configuration.getTemplate(location, this.deduceLocale()), model = this.createModel())) {
            try {
                PortletActionContext.getRenderResponse().setContentType(this.pContentType);
                template.process((Object)model, this.getWriter());
            }
            finally {
                this.postTemplateProcess(template, model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeResourceResult(String location, ActionInvocation invocation) throws TemplateException, IOException, PortletException {
        TemplateModel model;
        Template template;
        this.location = location;
        this.invocation = invocation;
        this.configuration = this.getConfiguration();
        this.wrapper = this.getObjectWrapper();
        HttpServletRequest req = ServletActionContext.getRequest();
        if (!location.startsWith("/")) {
            String base = ResourceUtil.getResourceBase((HttpServletRequest)req);
            location = base + "/" + location;
        }
        if (this.preTemplateProcess(template = this.configuration.getTemplate(location, this.deduceLocale()), model = this.createModel())) {
            try {
                ResourceResponse response = PortletActionContext.getResourceResponse();
                response.setContentType(this.pContentType);
                template.process((Object)model, (Writer)response.getWriter());
            }
            finally {
                this.postTemplateProcess(template, model);
            }
        }
    }

    protected Configuration getConfiguration() throws TemplateException {
        return this.freemarkerManager.getConfiguration(ServletActionContext.getServletContext());
    }

    protected ObjectWrapper getObjectWrapper() {
        return this.configuration.getObjectWrapper();
    }

    protected Writer getWriter() throws IOException {
        return PortletActionContext.getRenderResponse().getWriter();
    }

    protected TemplateModel createModel() throws TemplateModelException {
        ServletContext servletContext = ServletActionContext.getServletContext();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        ValueStack stack = ServletActionContext.getContext().getValueStack();
        return this.freemarkerManager.buildTemplateModel(stack, this.invocation.getAction(), servletContext, request, response, this.wrapper);
    }

    protected Locale deduceLocale() {
        return this.configuration.getLocale();
    }

    protected void postTemplateProcess(Template template, TemplateModel data) throws IOException {
    }

    protected boolean preTemplateProcess(Template template, TemplateModel model) throws IOException {
        Object attrContentType = template.getCustomAttribute("content_type");
        if (attrContentType != null) {
            ServletActionContext.getResponse().setContentType(attrContentType.toString());
        } else {
            String encoding;
            String contentType = this.getContentType();
            if (contentType == null) {
                contentType = "text/html";
            }
            if ((encoding = template.getEncoding()) != null) {
                contentType = contentType + "; charset=" + encoding;
            }
            ServletActionContext.getResponse().setContentType(contentType);
        }
        return true;
    }
}

