/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.junit.util;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;

public class TestUtils {
    private static final Pattern WHITESPACE_BLOCK = Pattern.compile("\\s+");

    public static String normalize(String json, boolean removeSpaces) {
        Matcher matcher = WHITESPACE_BLOCK.matcher(StringUtils.trim((String)json));
        if (removeSpaces) {
            return matcher.replaceAll("").replaceAll(" ", "");
        }
        return matcher.replaceAll("");
    }

    public static String normalize(URL url) throws Exception {
        return TestUtils.normalize(TestUtils.readContent(url), true);
    }

    public static boolean compare(URL url, String text) throws Exception {
        String writerString = TestUtils.normalize(text, true);
        String bufferString = TestUtils.normalize(TestUtils.readContent(url), true);
        return bufferString.equals(writerString);
    }

    public static void assertEquals(URL source, String text) throws Exception {
        String writerString = TestUtils.normalize(text, true);
        String bufferString = TestUtils.normalize(TestUtils.readContent(source), true);
        Assert.assertEquals((Object)bufferString, (Object)writerString);
    }

    public static String readContent(URL url) throws Exception {
        return TestUtils.readContent(url, StandardCharsets.UTF_8);
    }

    public static String readContent(URL url, Charset encoding) throws Exception {
        if (url == null) {
            throw new IllegalArgumentException("Unable to verify a null URL");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Unable to verify the URL using a null Charset");
        }
        return IOUtils.toString((InputStream)url.openStream(), (Charset)encoding);
    }
}

