/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.instance.notifier;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.MessageListener;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageQueue;

class InstanceNotifierEventMessageListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(InstanceNotifierEventMessageListener.class);
    private final InstanceNotifierEventMessageQueue messageQueue;

    public InstanceNotifierEventMessageListener(InstanceNotifierEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public void messageReceived(Message message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Instance notifier message received: %s", message.getText()));
            }
            this.messageQueue.add(message);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

