/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.initializer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.initializer.InitializerMessageProcessorChain;
import org.apache.stratos.messaging.message.receiver.initializer.InitializerEventMessageQueue;

public class InitializerEventMessageDelegator
implements Runnable {
    private static final Log log = LogFactory.getLog(InitializerEventMessageDelegator.class);
    private MessageProcessorChain processorChain;
    private InitializerEventMessageQueue messageQueue;
    private boolean terminated;

    public InitializerEventMessageDelegator(InitializerEventMessageQueue initializerEventMessageQueue) {
        this.messageQueue = initializerEventMessageQueue;
        this.processorChain = new InitializerMessageProcessorChain();
    }

    public void addEventListener(EventListener eventListener) {
        this.processorChain.addEventListener(eventListener);
    }

    @Override
    public void run() {
        block9: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Initializer event message delegator started");
                }
                while (!this.terminated) {
                    try {
                        Message message = (Message)this.messageQueue.take();
                        String type = message.getEventClassName();
                        String json = message.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Initializer event message [%s] received from queue: %s", type, this.messageQueue.getClass()));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delegating initializer event message: %s", type));
                        }
                        this.processorChain.process(type, json, null);
                    }
                    catch (InterruptedException ignore) {
                        log.info((Object)"Shutting down initializer event message delegator...");
                        this.terminate();
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve initializer event message", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Initializer event message delegator failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

