/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.application.signup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.MessageListener;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventMessageQueue;

class ApplicationSignUpEventMessageListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(ApplicationSignUpEventMessageListener.class);
    private final ApplicationSignUpEventMessageQueue messageQueue;

    public ApplicationSignUpEventMessageListener(ApplicationSignUpEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public void messageReceived(Message message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Application signup message received: %s", message.getText()));
            }
            this.messageQueue.add(message);
        }
        catch (Exception e) {
            String error = "An error occurred while receiving application signup event message";
            log.error((Object)error, (Throwable)e);
        }
    }
}

