/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Application;
import org.apache.stratos.messaging.domain.application.Applications;
import org.apache.stratos.messaging.domain.application.ClusterDataHolder;
import org.apache.stratos.messaging.domain.application.Group;
import org.apache.stratos.messaging.event.application.ApplicationUpdatedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.application.updater.ApplicationsUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationUpdatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationUpdatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Applications applications = (Applications)object;
        if (ApplicationUpdatedEvent.class.getName().equals(type)) {
            if (!applications.isInitialized()) {
                return false;
            }
            ApplicationUpdatedEvent event = (ApplicationUpdatedEvent)MessagingUtil.jsonToObject(message, ApplicationUpdatedEvent.class);
            if (event == null) {
                log.error((Object)"Unable to convert the JSON message to ApplicationCreatedEvent");
                return false;
            }
            ApplicationsUpdater.acquireWriteLockForApplications();
            try {
                boolean bl = this.doProcess(event, applications);
                return bl;
            }
            finally {
                ApplicationsUpdater.releaseWriteLockForApplications();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, applications);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ApplicationUpdatedEvent event, Applications applications) {
        if (event.getApplication() == null) {
            String errorMsg = "Application object of application updated event is invalid";
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (event.getApplication().getUniqueIdentifier() == null || event.getApplication().getUniqueIdentifier().isEmpty()) {
            String errorMsg = "App id of application updated event is invalid: [ " + event.getApplication().getUniqueIdentifier() + " ]";
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (applications.applicationExists(event.getApplication().getUniqueIdentifier())) {
            Application updatedApplication = event.getApplication();
            Application application = applications.getApplication(event.getApplication().getUniqueIdentifier());
            Set<Group> groups = application.getAllGroupsRecursively();
            for (Group group : groups) {
                Group updatedGroup = updatedApplication.getGroupRecursively(group.getUniqueIdentifier());
                if (updatedGroup != null) {
                    group.setGroupMaxInstances(updatedGroup.getGroupMaxInstances());
                    group.setGroupMinInstances(updatedGroup.getGroupMinInstances());
                    continue;
                }
                log.warn((Object)("[Goup] " + group.getUniqueIdentifier() + " cannot be found in [application] " + application.getUniqueIdentifier()));
            }
            Set<ClusterDataHolder> clusterDataHolders = application.getClusterDataRecursively();
            for (ClusterDataHolder dataHolder : clusterDataHolders) {
                Set<ClusterDataHolder> updatedClusters = updatedApplication.getClusterDataRecursively();
                boolean clusterFound = false;
                for (ClusterDataHolder updatedCluster : updatedClusters) {
                    if (!updatedCluster.getClusterId().equals(dataHolder.getClusterId())) continue;
                    dataHolder.setMinInstances(updatedCluster.getMinInstances());
                    dataHolder.setMaxInstances(updatedCluster.getMaxInstances());
                    clusterFound = true;
                    break;
                }
                if (clusterFound) continue;
                log.warn((Object)("[Cluster] " + dataHolder.getClusterId() + " cannot be found in [application] " + application.getUniqueIdentifier()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Application with id [ " + event.getApplication().getUniqueIdentifier() + " ] updated"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Application with id [ " + event.getApplication().getUniqueIdentifier() + " ] not exists"));
        }
        this.notifyEventListeners(event);
        return true;
    }
}

