/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.topology.lifecycle;

import java.io.Serializable;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.lifecycle.LifeCycleState;
import org.apache.stratos.messaging.event.topology.TopologyEvent;

public class LifeCycleStateManager<T extends LifeCycleState>
implements Serializable {
    private static Log log = LogFactory.getLog(LifeCycleStateManager.class);
    private Stack<T> stateStack;
    private String identifier;

    public LifeCycleStateManager(T initialState, String identifier) {
        this.identifier = identifier;
        this.stateStack = new Stack();
        this.stateStack.push(initialState);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Lifecycle state manager initialized: [identifier] %s [state] %s", identifier, initialState.toString()));
        }
    }

    public <S extends TopologyEvent> boolean isPreConditionsValid(T nextState, S topologyEvent) {
        return true;
    }

    public boolean isStateTransitionValid(T nextState) {
        return ((LifeCycleState)this.stateStack.peek()).getNextStates().contains(nextState);
    }

    public synchronized boolean changeState(T nextState) {
        boolean stateChanged = false;
        if (this.getCurrentState() != nextState) {
            this.stateStack.push(nextState);
            stateChanged = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Lifecycle state changed: [identifier] %s [prev-state] %s [current-state] %s ", this.getIdentifier(), this.getPreviousState(), this.getCurrentState()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Lifecycle state already changed: [identifier] %s [prev-state] %s [current-state] %s ", this.getIdentifier(), this.getPreviousState(), this.getCurrentState()));
        }
        if (log.isDebugEnabled()) {
            LifeCycleStateManager.printStateTransitions(this.stateStack, this.identifier);
        }
        return stateChanged;
    }

    public Stack<T> getStateStack() {
        return this.stateStack;
    }

    public T getCurrentState() {
        return (T)((LifeCycleState)this.stateStack.peek());
    }

    public T getPreviousState() {
        int index = this.stateStack.size() - 2;
        if (index >= 0 && index < this.stateStack.size()) {
            return (T)((LifeCycleState)this.stateStack.get(index));
        }
        return null;
    }

    private static <T extends LifeCycleState> void printStateTransitions(Stack<T> stateStack, String id) {
        StringBuilder stateTransitions = new StringBuilder("Transitioned states for " + id + ": [START]");
        for (LifeCycleState aStateStack : stateStack) {
            stateTransitions.append(aStateStack);
        }
        stateTransitions.append("[END]");
        log.debug((Object)stateTransitions);
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

