/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.connect.amqp;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.RetryTimer;
import org.apache.stratos.messaging.broker.connect.TopicPublisher;
import org.apache.stratos.messaging.broker.connect.amqp.AmqpTopicConnector;
import org.apache.stratos.messaging.domain.exception.MessagingException;

public class AmqpTopicPublisher
extends AmqpTopicConnector
implements TopicPublisher {
    private static final Log log = LogFactory.getLog(AmqpTopicConnector.class);
    private final String topicName;
    private ConnectionStatus connectionStatus;

    public AmqpTopicPublisher(String topicName) {
        this.topicName = topicName;
        this.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String message, boolean retry) {
        boolean published = false;
        while (!published) {
            TopicSession topicSession = null;
            javax.jms.TopicPublisher topicPublisher = null;
            try {
                while (this.connectionStatus == ConnectionStatus.ReConnecting) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore) {}
                }
                if (this.connectionStatus == ConnectionStatus.ReConnected) {
                    Thread.sleep(2000L);
                    this.connectionStatus = ConnectionStatus.Connected;
                }
                topicSession = this.newSession();
                Topic topic = this.lookupTopic(this.topicName);
                if (topic == null) {
                    topic = topicSession.createTopic(this.topicName);
                }
                topicPublisher = topicSession.createPublisher(topic);
                TextMessage textMessage = topicSession.createTextMessage(message);
                topicPublisher.publish((Message)textMessage);
                published = true;
            }
            catch (Exception e) {
                String errorMessage = "Could not publish to topic: [topic-name] %s";
                log.error((Object)errorMessage, (Throwable)e);
                if (!retry) {
                    throw new MessagingException(errorMessage, e);
                }
                this.reconnect();
            }
            finally {
                try {
                    if (topicSession != null) {
                        topicSession.close();
                    }
                    if (topicPublisher == null) continue;
                    topicPublisher.close();
                }
                catch (JMSException e) {
                    message = "Error cleaning up pubisher";
                    log.error((Object)message, (Throwable)e);
                    throw new MessagingException(message, e);
                }
            }
        }
    }

    @Override
    protected void reconnect() {
        this.connectionStatus = ConnectionStatus.ReConnecting;
        RetryTimer retryTimer = new RetryTimer();
        while (this.connectionStatus == ConnectionStatus.ReConnecting) {
            try {
                long interval = retryTimer.getNextInterval();
                log.info((Object)String.format("Topic publisher will try to reconnect in %d seconds: [topic-name] %s", interval / 1000L, this.topicName));
                Thread.sleep(interval);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                this.disconnect();
                this.create();
                this.connect();
                this.connectionStatus = ConnectionStatus.ReConnected;
                log.info((Object)String.format("Topic publisher reconnected: [topic-name] %s", this.topicName));
            }
            catch (Exception e) {
                String message = "Could not reconnect to message broker";
                log.warn((Object)message, (Throwable)e);
            }
        }
    }

    private static enum ConnectionStatus {
        Connected,
        ReConnecting,
        ReConnected;

    }
}

