/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.keystore;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.ICACertsLoader;
import org.wso2.securevault.SecureVaultException;

public class CACertsLoader
implements ICACertsLoader {
    private static Log log = LogFactory.getLog(CACertsLoader.class);

    public KeyStore loadTrustStore(String CACertificateFilesPath) {
        try {
            File[] certs;
            if (log.isDebugEnabled()) {
                log.debug("Creating KeyStore from given CA certificates in the given directory : " + CACertificateFilesPath);
            }
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null, null);
            File certsPath = new File(CACertificateFilesPath);
            for (File currentCert : certs = certsPath.listFiles()) {
                FileInputStream inStream = new FileInputStream(currentCert);
                BufferedInputStream bis = new BufferedInputStream(inStream);
                CertificateFactory certFactory = CertificateFactory.getInstance("X509");
                Certificate cert = certFactory.generateCertificate(bis);
                trustStore.setCertificateEntry(currentCert.getName(), cert);
                bis.close();
                inStream.close();
            }
            return trustStore;
        }
        catch (IOException e) {
            this.handleException("IOError when reading certificates from directory : " + CACertificateFilesPath, e);
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Error creating a KeyStore", e);
        }
        catch (KeyStoreException e) {
            this.handleException("Error creating a KeyStore", e);
        }
        catch (CertificateException e) {
            this.handleException("Error creating a KeyStore", e);
        }
        return null;
    }

    private void handleException(String msg, Exception e) {
        log.error(msg, e);
        throw new SecureVaultException(msg, e);
    }
}

