/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.CipherOperationMode;
import org.wso2.securevault.DecryptionProvider;
import org.wso2.securevault.EncodingHelper;
import org.wso2.securevault.EncryptionProvider;
import org.wso2.securevault.SecureVaultException;
import org.wso2.securevault.definition.CipherInformation;
import org.wso2.securevault.definition.IdentityKeyStoreInformation;
import org.wso2.securevault.definition.KeyStoreInformation;
import org.wso2.securevault.definition.TrustKeyStoreInformation;
import org.wso2.securevault.keystore.IdentityKeyStoreWrapper;
import org.wso2.securevault.keystore.KeyStoreWrapper;
import org.wso2.securevault.keystore.TrustKeyStoreWrapper;
import org.wso2.securevault.secret.SecretInformation;

public abstract class BaseCipher
implements EncryptionProvider,
DecryptionProvider {
    private CipherInformation cipherInformation;
    private KeyStoreInformation keystoreInformation;
    private static Log log = LogFactory.getLog(BaseCipher.class);
    private Cipher cipher;
    protected KeyStoreWrapper keyStoreWrapper;
    private Key key;

    protected BaseCipher(CipherInformation cipherInformation, KeyStoreInformation keystoreInformation) {
        this.cipherInformation = cipherInformation;
        this.keystoreInformation = keystoreInformation;
        if (keystoreInformation instanceof TrustKeyStoreInformation) {
            this.keyStoreWrapper = new TrustKeyStoreWrapper();
            ((TrustKeyStoreWrapper)this.keyStoreWrapper).init((TrustKeyStoreInformation)keystoreInformation);
        } else {
            this.keyStoreWrapper = new IdentityKeyStoreWrapper();
            IdentityKeyStoreInformation identityKeyStore = (IdentityKeyStoreInformation)keystoreInformation;
            SecretInformation secretInformation = identityKeyStore.getKeyPasswordProvider();
            if (secretInformation != null) {
                ((IdentityKeyStoreWrapper)this.keyStoreWrapper).init(identityKeyStore, secretInformation.getResolvedSecret());
            }
        }
        this.init();
    }

    protected BaseCipher(CipherInformation cipherInformation, KeyStoreWrapper keyStoreWrapper) {
        this.keyStoreWrapper = keyStoreWrapper;
        this.cipherInformation = cipherInformation;
        this.init();
    }

    protected BaseCipher(CipherInformation cipherInformation, Key key) {
        this.key = key;
        this.cipherInformation = cipherInformation;
        this.init();
    }

    private void init() {
        block12: {
            String algorithm = this.cipherInformation.getAlgorithm();
            CipherOperationMode opMode = this.cipherInformation.getCipherOperationMode();
            if (this.key == null) {
                this.key = this.getKey(opMode);
            }
            if (log.isDebugEnabled()) {
                log.debug("Initializing cipher with algorithm '" + algorithm + "' in mode '" + (Object)((Object)opMode) + "'");
            }
            try {
                String provider = this.cipherInformation.getProvider();
                if (provider != null && !"".equals(provider)) {
                    try {
                        this.cipher = Cipher.getInstance(algorithm, provider.trim());
                    }
                    catch (NoSuchProviderException e) {
                        throw new SecureVaultException("Invalid Provider : " + provider, log);
                    }
                } else {
                    this.cipher = Cipher.getInstance(algorithm);
                }
                if (opMode == CipherOperationMode.ENCRYPT) {
                    this.cipher.init(1, this.key);
                    break block12;
                }
                if (opMode == CipherOperationMode.DECRYPT) {
                    this.cipher.init(2, this.key);
                    break block12;
                }
                throw new SecureVaultException("Invalid mode : " + (Object)((Object)opMode), log);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecureVaultException("There is no algorithm support for '" + algorithm + "' in the operation mode '" + (Object)((Object)opMode) + "'" + e, log);
            }
            catch (NoSuchPaddingException e) {
                throw new SecureVaultException("There is no padding scheme  for '" + algorithm + "' in the operation mode '" + (Object)((Object)opMode) + "'" + e, log);
            }
            catch (InvalidKeyException e) {
                throw new SecureVaultException("Invalid key ", e, log);
            }
        }
    }

    public CipherInformation getCipherInformation() {
        return this.cipherInformation;
    }

    public KeyStoreInformation getKeyStoreInformation() {
        return this.keystoreInformation;
    }

    public abstract Key getKey(CipherOperationMode var1);

    private byte[] doCipherOperation(byte[] inputStream) {
        InputStream sourceStream = new ByteArrayInputStream(inputStream);
        if (this.cipherInformation.getInType() != null) {
            try {
                sourceStream = EncodingHelper.decode(sourceStream, this.cipherInformation.getInType());
            }
            catch (IOException e) {
                throw new SecureVaultException("IOError when decoding the input stream for cipher ", e, log);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream out = new CipherOutputStream(baos, this.cipher);
        byte[] buffer = new byte[64];
        try {
            int length;
            while ((length = sourceStream.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new SecureVaultException("IOError when reading the input stream for cipher ", e, log);
        }
        finally {
            try {
                sourceStream.close();
                out.flush();
                out.close();
            }
            catch (IOException ignored) {}
        }
        if (this.cipherInformation.getOutType() != null) {
            return EncodingHelper.encode(baos, this.cipherInformation.getOutType());
        }
        return baos.toByteArray();
    }

    public byte[] encrypt(byte[] plainText) {
        return this.doCipherOperation(plainText);
    }

    public byte[] decrypt(byte[] cipherText) {
        return this.doCipherOperation(cipherText);
    }
}

