/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WrappedDataHandler
extends DataHandler {
    private static final Log log = LogFactory.getLog(WrappedDataHandler.class);
    DataHandler delegate;
    String contentType;
    private static FakeDataSource FAKE_DS = new FakeDataSource();

    public WrappedDataHandler(DataHandler _delegate, String _contentType) {
        super((DataSource)FAKE_DS);
        this.delegate = _delegate;
        this.contentType = _contentType;
        if (log.isDebugEnabled()) {
            log.debug("Created instance of WrappedDatahandler: " + ((Object)((Object)this)).toString() + ", contentType=" + this.contentType + "\nDelegate DataHandler: " + this.delegate.toString());
        }
    }

    public CommandInfo[] getAllCommands() {
        return this.delegate.getAllCommands();
    }

    public Object getBean(CommandInfo paramCommandInfo) {
        return this.delegate.getBean(paramCommandInfo);
    }

    public CommandInfo getCommand(String paramString) {
        return this.delegate.getCommand(paramString);
    }

    public Object getContent() throws IOException {
        return this.delegate.getContent();
    }

    public String getContentType() {
        return this.contentType != null ? this.contentType : this.delegate.getContentType();
    }

    public DataSource getDataSource() {
        return this.delegate.getDataSource();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    public CommandInfo[] getPreferredCommands() {
        return this.delegate.getPreferredCommands();
    }

    public Object getTransferData(DataFlavor paramDataFlavor) throws UnsupportedFlavorException, IOException {
        return this.delegate.getTransferData(paramDataFlavor);
    }

    public synchronized DataFlavor[] getTransferDataFlavors() {
        return this.delegate.getTransferDataFlavors();
    }

    public boolean isDataFlavorSupported(DataFlavor paramDataFlavor) {
        return this.delegate.isDataFlavorSupported(paramDataFlavor);
    }

    public synchronized void setCommandMap(CommandMap paramCommandMap) {
        this.delegate.setCommandMap(paramCommandMap);
    }

    public void writeTo(OutputStream paramOutputStream) throws IOException {
        this.delegate.writeTo(paramOutputStream);
    }

    private static class FakeDataSource
    implements DataSource {
        private FakeDataSource() {
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "FakeDataSource";
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

