/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallbackReceiver
implements MessageReceiver {
    private static final Log log = LogFactory.getLog(CallbackReceiver.class);
    public static String SERVICE_NAME = "ClientService";
    protected ConcurrentHashMap callbackStore = new ConcurrentHashMap();

    public void addCallback(String msgID, AxisCallback callback) throws AxisFault {
        this.putIfAbsent(msgID, callback);
    }

    private void putIfAbsent(String msgID, Object callback) throws AxisFault {
        if (this.callbackStore.putIfAbsent(msgID, callback) == null) {
            if (log.isDebugEnabled()) {
                log.debug("CallbackReceiver: add callback " + msgID + ", " + callback + " ," + this);
            }
        } else {
            throw new AxisFault("The Callback for MessageID " + msgID + " is a duplicate");
        }
    }

    public Object lookupCallback(String msgID) {
        Object o = this.callbackStore.remove(msgID);
        if (log.isDebugEnabled()) {
            log.debug("CallbackReceiver: lookup callback " + msgID + ", " + o + " ," + this);
        }
        return o;
    }

    @Override
    public void receive(MessageContext msgContext) throws AxisFault {
        RelatesTo relatesTO = msgContext.getOptions().getRelatesTo();
        if (relatesTO == null) {
            throw new AxisFault("Cannot identify correct Callback object. RelatesTo is null");
        }
        String messageID = relatesTO.getValue();
        Object callbackObj = this.callbackStore.remove(messageID);
        if (log.isDebugEnabled()) {
            log.debug("CallbackReceiver: receive found callback " + callbackObj + ", " + messageID + ", " + this + ", " + msgContext.getAxisOperation());
        }
        if (callbackObj == null) {
            throw new AxisFault("The Callback for MessageID " + messageID + " was not found");
        }
        if (callbackObj instanceof AxisCallback) {
            AxisCallback axisCallback = (AxisCallback)callbackObj;
            if (msgContext.isFault()) {
                axisCallback.onFault(msgContext);
            } else {
                axisCallback.onMessage(msgContext);
            }
            axisCallback.onComplete();
            return;
        }
    }

    public Map getCallbackStore() {
        return this.callbackStore;
    }
}

