/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.receivers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.receivers.AbstractInMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RPCInOnlyMessageReceiver
extends AbstractInMessageReceiver {
    private static Log log = LogFactory.getLog(RPCInOnlyMessageReceiver.class);

    @Override
    public void invokeBusinessLogic(MessageContext inMessage) throws AxisFault {
        Method method = null;
        try {
            Object obj = this.getTheImplementationObject(inMessage);
            Class<?> ImplClass = obj.getClass();
            AxisOperation op = inMessage.getOperationContext().getAxisOperation();
            OMElement methodElement = inMessage.getEnvelope().getBody().getFirstElement();
            AxisMessage inAxisMessage = op.getMessage("In");
            String messageNameSpace = null;
            String methodName = op.getName().getLocalPart();
            Method[] methods = ImplClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].isBridge() || !methods[i].getName().equals(methodName)) continue;
                method = methods[i];
                break;
            }
            if (inAxisMessage != null) {
                RPCUtil.invokeServiceClass(inAxisMessage, method, obj, messageNameSpace, methodElement, inMessage);
            }
            this.replicateState(inMessage);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                String msg = cause.getMessage();
                if (msg == null) {
                    msg = "Exception occurred while trying to invoke service method " + method.getName();
                }
                log.error(msg, cause);
            } else {
                cause = e;
            }
            throw AxisFault.makeFault(cause);
        }
        catch (Exception e) {
            String msg = "Exception occurred while trying to invoke service method " + method.getName();
            log.error(msg, e);
            throw new AxisFault(msg, e);
        }
    }
}

