/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.mina;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;
import org.wso2.andes.transport.Sender;
import org.wso2.andes.transport.network.NetworkConnection;
import org.wso2.andes.transport.network.mina.MinaSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaNetworkConnection
implements NetworkConnection {
    private IoSession _session;
    private Sender<ByteBuffer> _sender;

    public MinaNetworkConnection(IoSession session) {
        this._session = session;
        this._sender = new MinaSender(this._session);
    }

    @Override
    public Sender<ByteBuffer> getSender() {
        return this._sender;
    }

    @Override
    public void close() {
        this._session.close();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._session.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._session.getLocalAddress();
    }

    public long getReadBytes() {
        return this._session.getReadBytes();
    }

    public long getWrittenBytes() {
        return this._session.getWrittenBytes();
    }

    @Override
    public void setMaxWriteIdle(int sec) {
        this._session.setIdleTime(IdleStatus.WRITER_IDLE, sec);
    }

    @Override
    public void setMaxReadIdle(int sec) {
        this._session.setIdleTime(IdleStatus.READER_IDLE, sec);
    }
}

