/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.countdownlatch;

import com.hazelcast.concurrent.countdownlatch.CountDownLatchInfo;
import com.hazelcast.concurrent.countdownlatch.CountDownLatchService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class CountDownLatchReplicationOperation
extends AbstractOperation {
    private Collection<CountDownLatchInfo> data;

    public CountDownLatchReplicationOperation() {
    }

    public CountDownLatchReplicationOperation(Collection<CountDownLatchInfo> data) {
        this.data = data;
    }

    @Override
    public void run() throws Exception {
        if (this.data != null) {
            CountDownLatchService service = (CountDownLatchService)this.getService();
            for (CountDownLatchInfo latch : this.data) {
                service.add(latch);
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int len = this.data != null ? this.data.size() : 0;
        out.writeInt(len);
        if (len > 0) {
            for (CountDownLatchInfo latch : this.data) {
                latch.writeData(out);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int len = in.readInt();
        if (len > 0) {
            this.data = new ArrayList<CountDownLatchInfo>();
            for (int i = 0; i < len; ++i) {
                CountDownLatchInfo latch = new CountDownLatchInfo();
                latch.readData(in);
                this.data.add(latch);
            }
        }
    }
}

