/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisEndpoint
extends AxisDescription {
    private static final Log logger = LogFactory.getLog(AxisEndpoint.class);
    private String name;
    private AxisBinding binding;
    private String endpointURL;
    private String alias;
    private Map<String, Object> options = new HashMap<String, Object>();
    private String transportInDescName;

    public String getEndpointURL() {
        if (this.endpointURL == null) {
            this.endpointURL = this.calculateEndpointURL();
        }
        return this.endpointURL;
    }

    public void setEndpointURL(String endpointURL) {
        this.endpointURL = endpointURL;
    }

    public void setProperty(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getProperty(String name) {
        Object obj = this.options.get(name);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AxisBinding getBinding() {
        return this.binding;
    }

    public void setBinding(AxisBinding binding) {
        this.binding = binding;
    }

    @Override
    public Object getKey() {
        return null;
    }

    @Override
    public void engageModule(AxisModule axisModule) throws AxisFault {
        throw new UnsupportedOperationException("Sorry we do not support this");
    }

    @Override
    public boolean isEngaged(String moduleName) {
        throw new UnsupportedOperationException("axisMessage.isEngaged() is not supported");
    }

    public OMElement toWSDL20(OMNamespace wsdl, OMNamespace tns, OMNamespace whttp) {
        String property;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = omFactory.createOMElement("endpoint", wsdl);
        endpointElement.addAttribute(omFactory.createOMAttribute("name", null, this.name));
        endpointElement.addAttribute(omFactory.createOMAttribute("binding", null, tns.getPrefix() + ":" + this.getBinding().getName().getLocalPart()));
        endpointElement.addAttribute(omFactory.createOMAttribute("address", null, this.getEndpointURL()));
        Object authenticationScheme = this.options.get("whttp:authenticationType");
        if (authenticationScheme != null) {
            endpointElement.addAttribute(omFactory.createOMAttribute("authenticationType", whttp, authenticationScheme.toString()));
        }
        if ((property = (String)this.options.get("whttp:authenticationRealm")) != null) {
            endpointElement.addAttribute(omFactory.createOMAttribute("authenticationRealm", whttp, property));
        }
        WSDLSerializationUtil.addWSDLDocumentationElement(this, endpointElement, omFactory, wsdl);
        WSDLSerializationUtil.addPoliciesAsExtensibleElement(this, endpointElement);
        return endpointElement;
    }

    public AxisService getAxisService() {
        return (AxisService)this.parent;
    }

    public void setParent(AxisService service) {
        this.parent = service;
    }

    public void setTransportInDescription(String transportInDescName) {
        this.transportInDescName = transportInDescName;
    }

    public String calculateEndpointURL() {
        return this.calculateEndpointURL(null);
    }

    public String calculateEndpointURL(String hostIP) {
        AxisConfiguration axisConfiguration;
        if (this.transportInDescName != null && this.parent != null && (axisConfiguration = this.getAxisConfiguration()) != null) {
            try {
                String serviceName = ((AxisService)this.parent).getName();
                TransportInDescription in = axisConfiguration.getTransportIn(this.transportInDescName);
                TransportListener listener = in.getReceiver();
                String ip = hostIP != null ? hostIP : Utils.getIpAddress(axisConfiguration);
                String sDOTe = serviceName + "." + this.name;
                EndpointReference[] eprsForService = listener.getEPRsForService(sDOTe, ip);
                if (eprsForService != null && eprsForService.length > 0) {
                    return eprsForService[0].getAddress();
                }
            }
            catch (SocketException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (AxisFault e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean isActive() {
        AxisConfiguration axisConfiguration;
        if (this.transportInDescName != null && this.parent != null && (axisConfiguration = this.getAxisConfiguration()) != null) {
            AxisService service = (AxisService)this.parent;
            if (service.isEnableAllTransports()) {
                return axisConfiguration.getTransportsIn().containsKey(this.transportInDescName);
            }
            return service.getExposedTransports().contains(this.transportInDescName);
        }
        return false;
    }
}

