/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.indexer;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassSession;
import org.compass.gps.device.jpa.EntityManagerWrapper;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.indexer.JpaIndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;

public class DefaultJpaIndexEntitiesIndexer
implements JpaIndexEntitiesIndexer {
    private static final Log log = LogFactory.getLog(DefaultJpaIndexEntitiesIndexer.class);
    private JpaGpsDevice jpaGpsDevice;

    public void setJpaGpsDevice(JpaGpsDevice jpaGpsDevice) {
        this.jpaGpsDevice = jpaGpsDevice;
    }

    public void performIndex(CompassSession session, IndexEntity[] entities) {
        block2: for (IndexEntity indexEntity : entities) {
            EntityInformation entityInformation = (EntityInformation)indexEntity;
            if (this.jpaGpsDevice.isFilteredForIndex(entityInformation.getName())) continue;
            int fetchCount = this.jpaGpsDevice.getFetchCount();
            int current = 0;
            while (this.jpaGpsDevice.isRunning()) {
                EntityManagerWrapper wrapper = this.jpaGpsDevice.getEntityManagerWrapper().newInstance();
                try {
                    wrapper.open();
                    EntityManager entityManager = wrapper.getEntityManager();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)this.jpaGpsDevice.buildMessage("Indexing entities [" + entityInformation.getName() + "] range [" + current + "-" + (current + fetchCount) + "] using query [" + entityInformation.getQueryProvider() + "]"));
                    }
                    Query query = entityInformation.getQueryProvider().createQuery(entityManager, entityInformation);
                    query.setFirstResult(current);
                    query.setMaxResults(fetchCount);
                    List results = query.getResultList();
                    for (Object result : results) {
                        session.create(result);
                    }
                    session.evictAll();
                    entityManager.clear();
                    wrapper.close();
                    if (results.size() < fetchCount) continue block2;
                    current += fetchCount;
                }
                catch (Exception e) {
                    log.error((Object)this.jpaGpsDevice.buildMessage("Failed to index the database"), (Throwable)e);
                    wrapper.closeOnError();
                    if (!(e instanceof JpaGpsDeviceException)) {
                        throw new JpaGpsDeviceException(this.jpaGpsDevice.buildMessage("Failed to index the database"), e);
                    }
                    throw (JpaGpsDeviceException)e;
                }
            }
            return;
        }
    }
}

