/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.InputStreamMappingResolver;
import org.compass.core.config.binding.MappingBinding;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.metadata.CompassMetaData;

public abstract class AbstractInputStreamMappingBinding
implements MappingBinding {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected CompassMapping mapping;
    protected CompassMetaData metaData;
    protected CompassSettings settings;

    public void setUpBinding(CompassMapping mapping, CompassMetaData metaData, CompassSettings settings) {
        this.mapping = mapping;
        this.metaData = metaData;
        this.settings = settings;
    }

    public boolean addResoruceMapping(ResourceMapping resourceMapping) throws ConfigurationException, MappingException {
        this.mapping.addMapping(resourceMapping);
        return true;
    }

    public boolean addResource(String path) throws ConfigurationException, MappingException {
        return this.addResource(path, this.settings.getClassLoader());
    }

    public boolean addResource(String path, ClassLoader classLoader) throws ConfigurationException, MappingException {
        InputStream rsrc = classLoader.getResourceAsStream(path);
        return rsrc != null && this.internalAddInputStream(rsrc, path, true);
    }

    public boolean addURL(URL url) throws ConfigurationException, MappingException {
        try {
            return this.internalAddInputStream(url.openStream(), url.toExternalForm(), true);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to open url [" + url.toExternalForm() + "]", e);
        }
    }

    public boolean addDirectory(File dir) throws ConfigurationException, MappingException {
        File[] files;
        boolean addedAtLeastOne = false;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                boolean retVal = this.addDirectory(file);
                if (!retVal) continue;
                addedAtLeastOne = true;
                continue;
            }
            for (String suffix : this.getSuffixes()) {
                boolean retVal;
                if (!file.getName().endsWith(suffix) || !(retVal = this.addFile(file))) continue;
                addedAtLeastOne = true;
            }
        }
        return addedAtLeastOne;
    }

    public boolean addJar(File jar) throws ConfigurationException, MappingException {
        JarFile jarFile;
        try {
            jarFile = new JarFile(jar);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Could not configure datastore from jar [" + jar.getName() + "]", ioe);
        }
        boolean addedAtLeastOne = false;
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            ZipEntry ze = jarEntries.nextElement();
            for (String suffix : this.getSuffixes()) {
                if (!ze.getName().endsWith(suffix)) continue;
                try {
                    boolean retVal = this.internalAddInputStream(jarFile.getInputStream(ze), ze.getName(), true);
                    if (!retVal) continue;
                    addedAtLeastOne = true;
                }
                catch (ConfigurationException me) {
                    throw me;
                }
                catch (Exception e) {
                    throw new ConfigurationException("Could not configure datastore from jar [" + jar.getAbsolutePath() + "]", e);
                }
            }
        }
        return addedAtLeastOne;
    }

    public boolean addFile(String filePath) throws ConfigurationException, MappingException {
        return this.addFile(new File(filePath));
    }

    public boolean addFile(File file) throws ConfigurationException, MappingException {
        try {
            return this.internalAddInputStream(new FileInputStream(file), file.getAbsolutePath(), true);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Could not configure mapping from file, file not found [" + file.getAbsolutePath() + "]", e);
        }
    }

    public boolean addPackage(String packageName) throws ConfigurationException, MappingException {
        return false;
    }

    public boolean addClass(Class clazz) throws ConfigurationException, MappingException {
        boolean addedAtLeaseOne = false;
        for (String suffix : this.getSuffixes()) {
            String fileName = clazz.getName().replace('.', '/') + suffix;
            InputStream rsrc = clazz.getClassLoader().getResourceAsStream(fileName);
            if (rsrc == null) continue;
            try {
                addedAtLeaseOne |= this.internalAddInputStream(rsrc, fileName, true);
            }
            catch (ConfigurationException me) {
                throw new ConfigurationException("Error reading resource [" + fileName + "]", me);
            }
        }
        return addedAtLeaseOne;
    }

    public boolean addMappingResolver(InputStreamMappingResolver mappingResolver) throws ConfigurationException, MappingException {
        return this.internalAddInputStream(mappingResolver.getMappingAsInputStream(), mappingResolver.getName(), true);
    }

    public boolean addInputStream(InputStream is, String resourceName) throws ConfigurationException, MappingException {
        return this.internalAddInputStream(is, resourceName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalAddInputStream(InputStream is, String resourceName, boolean closeStream) throws ConfigurationException, MappingException {
        try {
            boolean matchedOnSuffix = false;
            for (String suffix : this.getSuffixes()) {
                if (!resourceName.endsWith(suffix)) continue;
                matchedOnSuffix = true;
                break;
            }
            if (!matchedOnSuffix) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Resource name [" + resourceName + "] does not end with suffix [" + Arrays.toString(this.getSuffixes()) + "], ignoring"));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = this.doAddInputStream(is, resourceName);
            return bl;
        }
        finally {
            if (closeStream) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected abstract boolean doAddInputStream(InputStream var1, String var2) throws ConfigurationException, MappingException;
}

