/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import java.util.zip.DataFormatException;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.PUBLISH;

class MQTTSubscription {
    private final MQTTProtocolConverter protocolConverter;
    private final ConsumerInfo consumerInfo;
    private ActiveMQDestination destination;
    private final QoS qos;

    public MQTTSubscription(MQTTProtocolConverter protocolConverter, QoS qos, ConsumerInfo consumerInfo) {
        this.protocolConverter = protocolConverter;
        this.consumerInfo = consumerInfo;
        this.qos = qos;
    }

    MessageAck createMessageAck(MessageDispatch md) {
        return new MessageAck(md, 2, 1);
    }

    PUBLISH createPublish(ActiveMQMessage message) throws DataFormatException, IOException, JMSException {
        PUBLISH publish = this.protocolConverter.convertMessage(message);
        if (publish.qos().ordinal() > this.qos.ordinal()) {
            publish.qos(this.qos);
        }
        switch (publish.qos()) {
            case AT_LEAST_ONCE: 
            case EXACTLY_ONCE: {
                this.protocolConverter.getPacketIdGenerator().setPacketId(this.protocolConverter.getClientId(), this, message, publish);
            }
        }
        return publish;
    }

    public boolean expectAck(PUBLISH publish) {
        QoS publishQoS = publish.qos();
        if (publishQoS.compareTo((Enum)this.qos) > 0) {
            publishQoS = this.qos;
        }
        return !publishQoS.equals((Object)QoS.AT_MOST_ONCE);
    }

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    public QoS qos() {
        return this.qos;
    }
}

