/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.securevault;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.securevault.SecretCallbackHandlerException;
import org.wso2.securevault.secret.AbstractSecretCallbackHandler;
import org.wso2.securevault.secret.SingleSecretCallback;

public class DefaultSecretCallbackHandler
extends AbstractSecretCallbackHandler {
    private static Log log = LogFactory.getLog(DefaultSecretCallbackHandler.class);
    private static final String KEY_PASSWORD = "key.password";
    private static final String CARBON_HOME = "carbon.home";
    private static final String PERSIST_PASSWORD = "persist.password";
    private static String keyStorePassWord;
    private static String privateKeyPassWord;
    private static File keyDataFile;

    public void handleSingleSecretCallback(SingleSecretCallback singleSecretCallback) {
        if (keyStorePassWord == null && privateKeyPassWord == null) {
            String persistPasswordProperty;
            String textFilePersist;
            String textFileName_tmp;
            String textFileName;
            boolean sameKeyAndKeyStorePass = true;
            boolean persistPassword = false;
            String carbonHome = System.getProperty(CARBON_HOME);
            String osName = System.getProperty("os.name");
            if (osName.toLowerCase().indexOf("win") == -1) {
                textFileName = "password";
                textFileName_tmp = "password-tmp";
                textFilePersist = "password-persist";
            } else {
                textFileName = "password.txt";
                textFileName_tmp = "password-tmp.txt";
                textFilePersist = "password-persist.txt";
            }
            String keyPassword = System.getProperty(KEY_PASSWORD);
            if (keyPassword != null && keyPassword.trim().equals("true")) {
                sameKeyAndKeyStorePass = false;
            }
            if ((persistPasswordProperty = System.getProperty(PERSIST_PASSWORD)) != null && persistPasswordProperty.trim().equals("true")) {
                persistPassword = true;
            }
            if ((keyDataFile = new File(carbonHome + File.separator + textFileName)).exists()) {
                keyStorePassWord = this.readPassword(keyDataFile, sameKeyAndKeyStorePass);
                privateKeyPassWord = sameKeyAndKeyStorePass ? keyStorePassWord : this.readPassword(keyDataFile, sameKeyAndKeyStorePass);
                if (!persistPassword && !this.renameConfigFile(textFileName_tmp)) {
                    DefaultSecretCallbackHandler.handleException("Error renaming Password config File");
                }
            } else {
                keyDataFile = new File(carbonHome + File.separator + textFileName_tmp);
                if (keyDataFile.exists()) {
                    keyStorePassWord = this.readPassword(keyDataFile, sameKeyAndKeyStorePass);
                    privateKeyPassWord = sameKeyAndKeyStorePass ? keyStorePassWord : this.readPassword(keyDataFile, sameKeyAndKeyStorePass);
                    if (!persistPassword && !this.deleteConfigFile()) {
                        DefaultSecretCallbackHandler.handleException("Error deleting Password config File");
                    }
                } else {
                    keyDataFile = new File(carbonHome + File.separator + textFilePersist);
                    if (keyDataFile.exists()) {
                        keyStorePassWord = this.readPassword(keyDataFile, sameKeyAndKeyStorePass);
                        privateKeyPassWord = sameKeyAndKeyStorePass ? keyStorePassWord : this.readPassword(keyDataFile, sameKeyAndKeyStorePass);
                    } else if (sameKeyAndKeyStorePass) {
                        char[] password;
                        Console console = System.console();
                        if (console != null && (password = console.readPassword("[%s]", "Enter KeyStore and Private Key Password :")) != null) {
                            privateKeyPassWord = keyStorePassWord = String.valueOf(password);
                        }
                    } else {
                        char[] password;
                        Console console = System.console();
                        if (console != null && (password = console.readPassword("[%s]", "Enter KeyStore Password :")) != null) {
                            keyStorePassWord = String.valueOf(password);
                        }
                        if ((console = System.console()) != null && (password = console.readPassword("[%s]", "Enter Private Key Password : ")) != null) {
                            privateKeyPassWord = String.valueOf(password);
                        }
                    }
                }
            }
        }
        if (singleSecretCallback.getId().equals("identity.key.password")) {
            singleSecretCallback.setSecret(privateKeyPassWord);
        } else {
            singleSecretCallback.setSecret(keyStorePassWord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPassword(File file, boolean sameKeyAndKeyStorePass) {
        String stringLine = null;
        FileInputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            if (sameKeyAndKeyStorePass) {
                stringLine = bufferedReader.readLine();
            } else {
                stringLine = bufferedReader.readLine();
                stringLine = bufferedReader.readLine();
            }
        }
        catch (Exception e) {
            DefaultSecretCallbackHandler.handleException("Error reading password from text file ", e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Error closing output stream of text file");
            }
        }
        return stringLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteConfigFile() {
        FileOutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            outputStream = new FileOutputStream(keyDataFile);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            bufferedWriter.write("!@#$%^&*()SDFGHJZXCVBNM!@#$%^&*");
        }
        catch (Exception e) {
            DefaultSecretCallbackHandler.handleException("Error writing values to text file ", e);
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Error closing output stream of text file");
            }
        }
        return keyDataFile.exists() && keyDataFile.delete();
    }

    private boolean renameConfigFile(String fileName) {
        if (keyDataFile.exists()) {
            File newConfigFile = new File(System.getProperty(CARBON_HOME) + File.separator + fileName);
            return keyDataFile.renameTo(newConfigFile);
        }
        return false;
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SecretCallbackHandlerException(msg, e);
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SecretCallbackHandlerException(msg);
    }
}

