/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.common.topology;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.load.balancer.common.domain.Cluster;
import org.apache.stratos.load.balancer.common.domain.Member;
import org.apache.stratos.load.balancer.common.domain.Service;
import org.apache.stratos.load.balancer.common.domain.Topology;

public class TopologyProvider {
    private static final Log log = LogFactory.getLog(TopologyProvider.class);
    private Topology topology = new Topology();
    private Map<String, Cluster> clusterIdToClusterMap = new ConcurrentHashMap<String, Cluster>();
    private Map<String, Cluster> hostNameToClusterMap = new ConcurrentHashMap<String, Cluster>();
    private Map<String, Map<Integer, Cluster>> hostNameToTenantIdToClusterMap = new ConcurrentHashMap<String, Map<Integer, Cluster>>();
    private Map<String, String> memberHostNameToClusterHostNameMap = new ConcurrentHashMap<String, String>();

    public boolean serviceExists(String serviceName) {
        return this.topology.getService(serviceName) != null;
    }

    public void addService(Service service) {
        if (service != null) {
            this.topology.addService(service);
            log.info((Object)String.format("Service added: [service] %s", service.getServiceName()));
            Collection<Cluster> clusters = service.getClusters();
            if (clusters != null && clusters.size() > 0) {
                for (Cluster cluster : clusters) {
                    this.addCluster(cluster);
                }
            }
        }
    }

    public void addCluster(Cluster cluster) {
        if (cluster != null) {
            Collection<Member> members;
            Service service = this.topology.getService(cluster.getServiceName());
            if (service == null) {
                throw new RuntimeException(String.format("Could not add cluster, service not found: [service] %s", cluster.getServiceName()));
            }
            service.addCluster(cluster);
            this.clusterIdToClusterMap.put(cluster.getClusterId(), cluster);
            for (String hostName : cluster.getHostNames()) {
                this.hostNameToClusterMap.put(hostName, cluster);
            }
            if (cluster.getHostNames() != null && cluster.getHostNames().size() > 0) {
                log.info((Object)String.format("Cluster added to service: [service] %s [cluster] %s [hostnames] %s", cluster.getServiceName(), cluster.getClusterId(), cluster.getHostNames()));
            }
            if ((members = cluster.getMembers()) != null && members.size() > 0) {
                for (Member member : members) {
                    this.addMember(member);
                }
            }
        }
    }

    public void addMember(Member member) {
        Cluster cluster = this.getClusterByClusterId(member.getClusterId());
        if (cluster == null) {
            log.warn((Object)String.format("Could not add member, cluster not found: [cluster] %s", member.getClusterId()));
            return;
        }
        if (StringUtils.isBlank((String)member.getHostName())) {
            log.warn((Object)String.format("Could not add member, member hostname not found: [cluster] %s [member] %s", member.getClusterId(), member.getMemberId()));
            return;
        }
        cluster.addMember(member);
        if (cluster.getHostNames() != null && cluster.getHostNames().size() > 0) {
            this.memberHostNameToClusterHostNameMap.put(member.getHostName(), cluster.getHostNames().iterator().next());
        }
        log.info((Object)String.format("Member added to cluster: [cluster] %s [member] %s", member.getClusterId(), member.getHostName()));
    }

    public void removeCluster(String clusterId) {
        Cluster cluster = this.getClusterByClusterId(clusterId);
        if (cluster == null) {
            log.warn((Object)String.format("Could not remove cluster, cluster not found: [cluster] %s", clusterId));
            return;
        }
        for (String hostName : cluster.getHostNames()) {
            this.hostNameToClusterMap.remove(hostName);
        }
        this.clusterIdToClusterMap.remove(cluster.getClusterId());
        if (cluster.getHostNames() != null && cluster.getHostNames().size() > 0) {
            log.info((Object)String.format("Cluster removed: [cluster] %s [hostnames] %s", cluster.getClusterId(), cluster.getHostNames()));
        }
    }

    public boolean clusterExistsByClusterId(String clusterId) {
        return this.getClusterByClusterId(clusterId) != null;
    }

    public boolean clusterExistsByHostName(String hostName) {
        return this.hostNameToClusterMap.containsKey(hostName) || this.hostNameToTenantIdToClusterMap.containsKey(hostName);
    }

    public Cluster getClusterByClusterId(String clusterId) {
        return this.clusterIdToClusterMap.get(clusterId);
    }

    public void addTenantSignUp(String clusterId, int tenantId) {
        Cluster cluster = this.getClusterByClusterId(clusterId);
        if (cluster != null) {
            boolean subscribed = false;
            for (String hostName : cluster.getHostNames()) {
                Map<Integer, Cluster> tenantIdToClusterMap = this.hostNameToTenantIdToClusterMap.get(hostName);
                if (tenantIdToClusterMap == null) {
                    tenantIdToClusterMap = new ConcurrentHashMap<Integer, Cluster>();
                    this.hostNameToTenantIdToClusterMap.put(hostName, tenantIdToClusterMap);
                }
                tenantIdToClusterMap.put(tenantId, cluster);
                subscribed = true;
            }
            if (subscribed) {
                log.info((Object)String.format("Tenant signed up to cluster: [tenant] %d [cluster] %s [hostnames] %s", tenantId, cluster.getClusterId(), cluster.getHostNames()));
            }
        }
    }

    public void removeTenantSignUp(String clusterId, int tenantId) {
        Cluster cluster = this.getClusterByClusterId(clusterId);
        if (cluster == null) {
            log.warn((Object)String.format("Could not remove tenant signup from cluster, cluster not found: [cluster] %s", clusterId));
        }
        for (String hostName : cluster.getHostNames()) {
            Cluster cluster_;
            Map<Integer, Cluster> tenantIdToClusterMap = this.hostNameToTenantIdToClusterMap.get(hostName);
            if (tenantIdToClusterMap == null || (cluster_ = tenantIdToClusterMap.get(tenantId)) == null) continue;
            tenantIdToClusterMap.remove(tenantId);
            log.info((Object)String.format("Tenant signup removed from cluster: [tenant] %d [cluster] %s [hostnames] %s", tenantId, cluster.getClusterId(), cluster.getHostNames()));
        }
    }

    public Cluster getClusterByHostName(String hostName) {
        return this.hostNameToClusterMap.get(hostName);
    }

    public Cluster getClusterByHostName(String hostName, int tenantId) {
        Map<Integer, Cluster> tenantIdToClusterMap = this.hostNameToTenantIdToClusterMap.get(hostName);
        if (tenantIdToClusterMap != null) {
            return tenantIdToClusterMap.get(tenantId);
        }
        return null;
    }

    public void removeMember(String clusterId, String memberId) {
        Cluster cluster = this.getClusterByClusterId(clusterId);
        if (cluster == null) {
            log.warn((Object)String.format("Could not remove member, cluster not found: [cluster] %s", clusterId));
            return;
        }
        Member member = cluster.getMember(memberId);
        if (member != null) {
            cluster.removeMember(memberId);
            if (this.memberHostNameToClusterHostNameMap.containsKey(member.getHostName())) {
                this.memberHostNameToClusterHostNameMap.remove(member.getHostName());
            }
            log.info((Object)String.format("Member removed from cluster: [cluster] %s [member] %s", clusterId, member.getHostName()));
            if (cluster.getMembers().size() == 0) {
                log.info((Object)String.format("No members found in cluster, removing cluster: [cluster] %s", cluster.getClusterId()));
                this.removeCluster(cluster.getClusterId());
            }
        }
    }

    public String getClusterHostname(String memberHostName) {
        return this.memberHostNameToClusterHostNameMap.get(memberHostName);
    }

    public Topology getTopology() {
        return this.topology;
    }
}

