/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.lb;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.agent.thrift.Agent;
import org.wso2.carbon.databridge.agent.thrift.AgentHolder;
import org.wso2.carbon.databridge.agent.thrift.AsyncDataPublisher;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.agent.thrift.lb.ReceiverGroup;
import org.wso2.carbon.databridge.agent.thrift.util.DataPublisherUtil;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class LoadBalancingDataPublisher {
    private static Log log = LogFactory.getLog(AsyncDataPublisher.class);
    private ArrayList<ReceiverGroup> receiverGroups;
    private ConcurrentHashMap<String, String> streamDefnCache = new ConcurrentHashMap();

    public LoadBalancingDataPublisher(ArrayList<ReceiverGroup> receiverGroups) {
        this.receiverGroups = receiverGroups;
        for (ReceiverGroup group : receiverGroups) {
            group.createDataPublishers(AgentHolder.getOrCreateAgent(), this.streamDefnCache);
        }
    }

    public LoadBalancingDataPublisher(ArrayList<ReceiverGroup> receiverGroups, Agent agent) {
        this.receiverGroups = receiverGroups;
        AgentHolder.setAgent(agent);
        for (ReceiverGroup group : receiverGroups) {
            group.createDataPublishers(agent, this.streamDefnCache);
        }
    }

    public LoadBalancingDataPublisher(ArrayList<ReceiverGroup> receiverGroups, Agent agent, boolean shareStreamDefinitionCache) {
        this.receiverGroups = receiverGroups;
        AgentHolder.setAgent(agent);
        if (shareStreamDefinitionCache) {
            for (ReceiverGroup group : receiverGroups) {
                group.createDataPublishers(agent, this.streamDefnCache);
            }
        } else {
            for (ReceiverGroup group : receiverGroups) {
                group.createDataPublishers(agent, null);
            }
        }
    }

    public void addReceiverGroup(ReceiverGroup aReceiverGroup) {
        aReceiverGroup.createDataPublishers(AgentHolder.getOrCreateAgent(), this.streamDefnCache);
        this.receiverGroups.add(aReceiverGroup);
    }

    public void publish(String streamName, String streamVersion, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) throws AgentException {
        for (ReceiverGroup aGroup : this.receiverGroups) {
            aGroup.publish(streamName, streamVersion, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap);
        }
    }

    public void publish(String streamName, String streamVersion, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) throws AgentException {
        for (ReceiverGroup aGroup : this.receiverGroups) {
            aGroup.publish(streamName, streamVersion, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, null);
        }
    }

    public void publish(String streamName, String streamVersion, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) throws AgentException {
        for (ReceiverGroup aGroup : this.receiverGroups) {
            aGroup.publish(streamName, streamVersion, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap);
        }
    }

    public void publish(String streamName, String streamVersion, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) throws AgentException {
        for (ReceiverGroup aGroup : this.receiverGroups) {
            aGroup.publish(streamName, streamVersion, metaDataArray, correlationDataArray, payloadDataArray, null);
        }
    }

    public void publish(String streamName, String streamVersion, Event event) throws AgentException {
        for (ReceiverGroup aGroup : this.receiverGroups) {
            aGroup.publish(streamName, streamVersion, event);
        }
    }

    public void publish(Event event) throws AgentException {
        for (ReceiverGroup aGroup : this.receiverGroups) {
            aGroup.publish(event);
        }
    }

    public void addStreamDefinition(String streamDefn, String streamName, String version) {
        for (ReceiverGroup group : this.receiverGroups) {
            group.addStreamDefinition(streamDefn, streamName, version);
        }
    }

    public void addStreamDefinition(StreamDefinition definition) {
        for (ReceiverGroup group : this.receiverGroups) {
            group.addStreamDefinition(definition);
        }
    }

    public boolean isStreamDefinitionAdded(String streamName, String version) {
        String key = DataPublisherUtil.getStreamCacheKey(streamName, version);
        return null != this.streamDefnCache.get(key);
    }

    public boolean isStreamDefinitionAdded(StreamDefinition streamDefinition) {
        String key = DataPublisherUtil.getStreamCacheKey(streamDefinition.getName(), streamDefinition.getVersion());
        return null != this.streamDefnCache.get(key);
    }

    public void stop() {
        for (ReceiverGroup group : this.receiverGroups) {
            group.stop();
        }
    }
}

