/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.MessageListener;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageQueue;

class TopologyEventMessageListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(TopologyEventMessageListener.class);
    private final TopologyEventMessageQueue messageQueue;

    public TopologyEventMessageListener(TopologyEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public void messageReceived(Message message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Topology message received: %s", message.getText()));
            }
            this.messageQueue.add(message);
        }
        catch (Exception e) {
            log.error((Object)"Adding the received message to the internal message queue got failed", (Throwable)e);
        }
    }
}

