/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ServiceCreatedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.updater.TopologyUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ServiceCreatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ServiceCreatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ServiceCreatedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ServiceCreatedEvent event = (ServiceCreatedEvent)MessagingUtil.jsonToObject(message, ServiceCreatedEvent.class);
            TopologyUpdater.acquireWriteLockForServices();
            try {
                boolean bl = this.doProcess(event, topology);
                return bl;
            }
            finally {
                TopologyUpdater.releaseWriteLockForServices();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ServiceCreatedEvent event, Topology topology) {
        String serviceName = event.getServiceName();
        if (TopologyServiceFilter.apply(serviceName)) {
            return false;
        }
        if (topology.serviceExists(event.getServiceName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Service already created: [service] %s", event.getServiceName()));
            }
        } else {
            Service service = new Service(event.getServiceName(), event.getServiceType());
            service.addPorts(event.getPorts());
            topology.addService(service);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Service created: [service] %s", event.getServiceName()));
            }
        }
        this.notifyEventListeners(event);
        return true;
    }
}

