/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Application;
import org.apache.stratos.messaging.domain.application.Applications;
import org.apache.stratos.messaging.event.application.CompleteApplicationsEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.application.updater.ApplicationsUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class CompleteApplicationsMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(CompleteApplicationsMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Applications applications = (Applications)object;
        if (CompleteApplicationsEvent.class.getName().equals(type)) {
            CompleteApplicationsEvent event = (CompleteApplicationsEvent)MessagingUtil.jsonToObject(message, CompleteApplicationsEvent.class);
            if (!applications.isInitialized()) {
                ApplicationsUpdater.acquireWriteLockForApplications();
                try {
                    this.doProcess(event, applications);
                }
                finally {
                    ApplicationsUpdater.releaseWriteLockForApplications();
                }
            }
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, applications);
        }
        return false;
    }

    private void doProcess(CompleteApplicationsEvent event, Applications applications) {
        Collection<Application> applicationsList = event.getApplications().getApplications().values();
        if (applicationsList != null && !applicationsList.isEmpty()) {
            for (Application application : applicationsList) {
                applications.addApplication(application);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Application with id [ " + application.getUniqueIdentifier() + " ] added to Applications"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No Application information found in Complete Applications event");
        }
        applications.setInitialized(true);
    }
}

