/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.filter.topology;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.message.filter.MessageFilter;

public class TopologyServiceFilter
extends MessageFilter {
    private static final Log log = LogFactory.getLog(TopologyServiceFilter.class);
    public static final String TOPOLOGY_SERVICE_FILTER_SERVICE_NAME = "service-name";
    private static volatile TopologyServiceFilter instance;

    public TopologyServiceFilter() {
        super("stratos.topology.service.filter");
    }

    public static boolean apply(String serviceName) {
        boolean excluded = false;
        if (TopologyServiceFilter.getInstance().isActive()) {
            if (StringUtils.isNotBlank((CharSequence)serviceName) && TopologyServiceFilter.getInstance().serviceExcluded(serviceName)) {
                excluded = true;
            }
            if (excluded && log.isInfoEnabled()) {
                log.info((Object)String.format("Service is excluded: [service-name] %s", serviceName));
            }
        }
        return excluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TopologyServiceFilter getInstance() {
        if (instance != null) return instance;
        Class<TopologyServiceFilter> clazz = TopologyServiceFilter.class;
        synchronized (TopologyServiceFilter.class) {
            if (instance != null) return instance;
            instance = new TopologyServiceFilter();
            if (!log.isDebugEnabled()) return instance;
            log.debug((Object)"Topology service filter instance created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private boolean serviceExcluded(String value) {
        return this.excluded(TOPOLOGY_SERVICE_FILTER_SERVICE_NAME, value);
    }

    private Collection<String> getIncludedServiceNames() {
        return this.getIncludedPropertyValues(TOPOLOGY_SERVICE_FILTER_SERVICE_NAME);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("service-name=");
        for (String clusterId : TopologyServiceFilter.getInstance().getIncludedServiceNames()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(clusterId);
        }
        return sb.toString();
    }
}

