/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.application;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.stratos.messaging.domain.application.ClusterDataHolder;
import org.apache.stratos.messaging.domain.application.DependencyOrder;
import org.apache.stratos.messaging.domain.application.Group;
import org.apache.stratos.messaging.domain.instance.Instance;

public abstract class ParentComponent<T extends Instance>
implements Serializable {
    protected final Map<String, Group> aliasToGroupMap = new HashMap<String, Group>();
    protected final Map<String, ClusterDataHolder> aliasToClusterDataMap = new HashMap<String, ClusterDataHolder>();
    private final Map<String, ClusterDataHolder> typeToClusterDataMap = new HashMap<String, ClusterDataHolder>();
    private Map<String, String> aliasToDeploymentPolicyIdMap;
    private Map<String, T> instanceIdToInstanceContextMap;
    private DependencyOrder dependencyOrder;
    private boolean isGroupScalingEnabled = false;
    private boolean isGroupInstanceMonitoringEnabled = false;
    private String deploymentPolicy;
    private AtomicInteger instanceIdSequence = new AtomicInteger();

    public abstract String getUniqueIdentifier();

    public void addGroup(Group group) {
        this.aliasToGroupMap.put(group.getUniqueIdentifier(), group);
    }

    public Group getGroup(String groupAlias) {
        return this.aliasToGroupMap.get(groupAlias);
    }

    public Group getGroupRecursively(String groupAlias) {
        return this.travereAndCheckRecursively(this.aliasToGroupMap, groupAlias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Group travereAndCheckRecursively(Map<String, Group> aliasToGroupMap, String groupAlias) {
        if (aliasToGroupMap.containsKey(groupAlias)) {
            Map<String, Group> map = aliasToGroupMap;
            synchronized (map) {
                if (aliasToGroupMap.containsKey(groupAlias)) {
                    return aliasToGroupMap.get(groupAlias);
                }
            }
        } else {
            for (Group group : aliasToGroupMap.values()) {
                Group foundGroup = this.travereAndCheckRecursively(group.getAliasToGroupMap(), groupAlias);
                if (foundGroup == null) continue;
                return foundGroup;
            }
        }
        return null;
    }

    public ClusterDataHolder getClusterDataHolderRecursivelyByAlias(String alias) {
        if (this.aliasToClusterDataMap.containsKey(alias)) {
            return this.aliasToClusterDataMap.get(alias);
        }
        ClusterDataHolder foundDataHolder = this.traverseAndCheckClusterDataHolderRecursively(this.aliasToGroupMap, alias);
        if (foundDataHolder != null) {
            return foundDataHolder;
        }
        return null;
    }

    private ClusterDataHolder traverseAndCheckClusterDataHolderRecursively(Map<String, Group> aliasToGroupMap, String alias) {
        for (Group group : aliasToGroupMap.values()) {
            if (group.getClusterDataMap() == null || group.getClusterDataMap().isEmpty() || group.getClusterData(alias) == null) continue;
            return group.getClusterData(alias);
        }
        for (Group group : aliasToGroupMap.values()) {
            ClusterDataHolder foundDataHolder;
            if (group.getGroups() == null || (foundDataHolder = this.traverseAndCheckClusterDataHolderRecursively(group.getAliasToGroupMap(), alias)) == null) continue;
            return foundDataHolder;
        }
        return null;
    }

    public Map<String, Group> getAliasToGroupMap() {
        return this.aliasToGroupMap;
    }

    public Map<String, ClusterDataHolder> getClusterDataMap() {
        return this.aliasToClusterDataMap;
    }

    public Collection<Group> getGroups() {
        return this.aliasToGroupMap.values();
    }

    public void setGroups(Map<String, Group> groupAliasToGroup) {
        this.aliasToGroupMap.putAll(groupAliasToGroup);
    }

    public DependencyOrder getDependencyOrder() {
        return this.dependencyOrder;
    }

    public void setDependencyOrder(DependencyOrder dependencyOrder) {
        this.dependencyOrder = dependencyOrder;
    }

    public void setClusterData(Map<String, ClusterDataHolder> aliasToClusterData) {
        this.aliasToClusterDataMap.putAll(aliasToClusterData);
    }

    public ClusterDataHolder getClusterData(String alias) {
        return this.aliasToClusterDataMap.get(alias);
    }

    public Set<ClusterDataHolder> getClusterDataRecursively() {
        HashSet<ClusterDataHolder> appClusterData = new HashSet<ClusterDataHolder>();
        if (this.aliasToClusterDataMap != null && !this.aliasToClusterDataMap.isEmpty()) {
            appClusterData.addAll(this.aliasToClusterDataMap.values());
        }
        if (this.getGroups() != null) {
            this.getClusterData(appClusterData, this.getGroups());
        }
        return appClusterData;
    }

    public Set<Group> getAllGroupsRecursively() {
        HashSet<Group> appGroups = new HashSet<Group>();
        if (this.aliasToGroupMap != null && !this.aliasToGroupMap.isEmpty()) {
            appGroups.addAll(this.aliasToGroupMap.values());
        }
        if (this.getGroups() != null) {
            this.getGroupsRecursively(appGroups, this.getGroups());
        }
        return appGroups;
    }

    public void addInstance(String instanceId, T instance) {
        this.getInstanceIdToInstanceContextMap().put(instanceId, instance);
    }

    public void removeInstance(String instanceId) {
        this.getInstanceIdToInstanceContextMap().remove(instanceId);
    }

    public boolean containsInstanceContext(String instanceId) {
        return this.getInstanceIdToInstanceContextMap().containsKey(instanceId);
    }

    public T getInstanceContexts(String instanceId) {
        if (this.getInstanceIdToInstanceContextMap().isEmpty()) {
            return null;
        }
        if (instanceId == null) {
            return (T)((Instance)this.getInstanceIdToInstanceContextMap().entrySet().iterator().next().getValue());
        }
        return (T)((Instance)this.getInstanceIdToInstanceContextMap().get(instanceId));
    }

    public List<Instance> getInstanceContextsWithParentId(String parentInstanceId) {
        ArrayList<Instance> contexts = new ArrayList<Instance>();
        if (this.getInstanceIdToInstanceContextMap().isEmpty()) {
            return contexts;
        }
        if (parentInstanceId != null) {
            for (Instance context : this.getInstanceIdToInstanceContextMap().values()) {
                if (!parentInstanceId.equals(context.getParentId())) continue;
                contexts.add(context);
            }
        }
        return contexts;
    }

    public int getInstanceContextCount() {
        return this.getInstanceIdToInstanceContextMap().keySet().size();
    }

    public int getComponentsCount() {
        return this.getClusterDataMap().keySet().size() + this.getAliasToGroupMap().keySet().size();
    }

    protected void getClusterData(Set<ClusterDataHolder> clusterData, Collection<Group> groups) {
        for (Group group : groups) {
            if (group.getClusterDataMap() != null && !group.getClusterDataMap().isEmpty()) {
                clusterData.addAll(group.getClusterDataMap().values());
            }
            if (group.getGroups() == null || group.getGroups().isEmpty()) continue;
            this.getClusterData(clusterData, group.getGroups());
        }
    }

    protected void getGroupsRecursively(Set<Group> groupsSet, Collection<Group> groups) {
        for (Group group : groups) {
            if (group.getGroups() == null || group.getGroups().isEmpty()) continue;
            groupsSet.addAll(group.getGroups());
            if (group.getGroups() == null) continue;
            this.getGroupsRecursively(groupsSet, group.getGroups());
        }
    }

    public Map<String, T> getInstanceIdToInstanceContextMap() {
        return this.instanceIdToInstanceContextMap;
    }

    public boolean isGroupScalingEnabled() {
        return this.isGroupScalingEnabled;
    }

    public void setGroupScalingEnabled(boolean isGroupScalingEnabled) {
        this.isGroupScalingEnabled = isGroupScalingEnabled;
    }

    public boolean isGroupInstanceMonitoringEnabled() {
        return this.isGroupInstanceMonitoringEnabled;
    }

    public void setGroupInstanceMonitoringEnabled(boolean isGroupInstanceMonitoringEnabled) {
        this.isGroupInstanceMonitoringEnabled = isGroupInstanceMonitoringEnabled;
    }

    public String getDeploymentPolicy() {
        return this.deploymentPolicy;
    }

    public void setDeploymentPolicy(String deploymentPolicy) {
        this.deploymentPolicy = deploymentPolicy;
    }

    public String getNextInstanceId(String alias) {
        int nextSequence = this.instanceIdSequence.incrementAndGet();
        String instanceId = alias + "-" + nextSequence;
        return instanceId;
    }

    public void setInstanceIdToInstanceContextMap(Map<String, T> instanceIdToInstanceContextMap) {
        this.instanceIdToInstanceContextMap = instanceIdToInstanceContextMap;
    }

    public Map<String, ClusterDataHolder> getClusterDataForType() {
        return this.typeToClusterDataMap;
    }

    public Map<String, ClusterDataHolder> getClusterDataForAlias() {
        return this.aliasToClusterDataMap;
    }

    public void setClusterDataForType(Map<String, ClusterDataHolder> typeToClusterData) {
        this.typeToClusterDataMap.putAll(typeToClusterData);
    }

    public Map<String, String> getAliasToDeploymentPolicyIdMap() {
        return this.aliasToDeploymentPolicyIdMap;
    }

    public void setAliasToDeploymentPolicyIdMap(Map<String, String> aliasToDeploymentPolicyIdMap) {
        this.aliasToDeploymentPolicyIdMap = aliasToDeploymentPolicyIdMap;
    }
}

