/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Vector;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsCallback
implements Runnable {
    private static int INBOUND_QUEUE_SIZE = 10;
    private MqttCallback mqttCallback;
    private ClientComms clientComms;
    private Vector messageQueue;
    private Vector completeQueue;
    public boolean running = false;
    private boolean quiescing = false;
    private Object lifecycle = new Object();
    private Thread callbackThread;
    private Object workAvailable = new Object();
    private Object spaceAvailable = new Object();
    private ClientState clientState;
    static final String className = CommsCallback.class.getName();
    Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", className);

    CommsCallback(ClientComms clientComms) {
        this.clientComms = clientComms;
        this.messageQueue = new Vector(INBOUND_QUEUE_SIZE);
        this.completeQueue = new Vector(INBOUND_QUEUE_SIZE);
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.messageQueue.clear();
                this.completeQueue.clear();
                this.running = true;
                this.quiescing = false;
                this.callbackThread = new Thread((Runnable)this, threadName);
                this.callbackThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.running) {
                this.log.fine(className, "stop", "700");
                this.running = false;
                if (!Thread.currentThread().equals(this.callbackThread)) {
                    try {
                        Object object2 = this.workAvailable;
                        synchronized (object2) {
                            this.log.fine(className, "stop", "701");
                            this.workAvailable.notifyAll();
                        }
                        this.callbackThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.callbackThread = null;
            this.log.fine(className, "stop", "703");
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String methodName = "run";
        while (this.running) {
            try {
                Object message;
                try {
                    Object object = this.workAvailable;
                    synchronized (object) {
                        if (this.running & this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                            this.log.fine(className, "run", "704");
                            this.workAvailable.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.running) {
                    if (!this.completeQueue.isEmpty()) {
                        MqttToken token = (MqttToken)this.completeQueue.elementAt(0);
                        this.handleActionComplete(token);
                        this.completeQueue.removeElementAt(0);
                    }
                    if (!this.messageQueue.isEmpty()) {
                        message = (MqttPublish)this.messageQueue.elementAt(0);
                        this.handleMessage((MqttPublish)message);
                        this.messageQueue.removeElementAt(0);
                    }
                }
                if (this.quiescing) {
                    this.clientState.checkQuiesceLock();
                }
                message = this.spaceAvailable;
                synchronized (message) {
                    this.log.fine(className, "run", "706");
                    this.spaceAvailable.notifyAll();
                }
            }
            catch (Throwable ex) {
                this.log.fine(className, "run", "714", null, ex);
                this.running = false;
                this.clientComms.shutdownConnection(null, new MqttException(ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActionComplete(MqttToken token) throws MqttException {
        String methodName = "handleActionComplete";
        MqttToken mqttToken = token;
        synchronized (mqttToken) {
            this.log.fine(className, "handleActionComplete", "705", new Object[]{token.internalTok.getKey()});
            token.internalTok.notifyComplete();
            if (!token.internalTok.isNotified()) {
                if (this.mqttCallback != null && token instanceof MqttDeliveryToken && token.isComplete()) {
                    this.mqttCallback.deliveryComplete((MqttDeliveryToken)token);
                }
                this.fireActionEvent(token);
            }
            if (token instanceof MqttDeliveryToken && token.isComplete()) {
                token.internalTok.setNotified(true);
            }
            if (token.isComplete()) {
                this.clientState.notifyComplete(token);
            }
        }
    }

    public void connectionLost(MqttException cause) {
        String methodName = "connectionLost";
        try {
            if (this.mqttCallback != null && cause != null) {
                this.log.fine(className, "connectionLost", "708", new Object[]{cause});
                this.mqttCallback.connectionLost(cause);
            }
        }
        catch (Throwable t) {
            this.log.fine(className, "connectionLost", "720", new Object[]{t});
        }
    }

    public void fireActionEvent(MqttToken token) {
        IMqttActionListener asyncCB;
        String methodName = "fireActionEvent";
        if (token != null && (asyncCB = token.getActionCallback()) != null) {
            if (token.getException() == null) {
                this.log.fine(className, "fireActionEvent", "716", new Object[]{token.internalTok.getKey()});
                asyncCB.onSuccess(token);
            } else {
                this.log.fine(className, "fireActionEvent", "716", new Object[]{token.internalTok.getKey()});
                asyncCB.onFailure(token, token.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(MqttPublish sendMessage) {
        String methodName = "messageArrived";
        if (this.mqttCallback != null) {
            Object object = this.spaceAvailable;
            synchronized (object) {
                if (!this.quiescing && this.messageQueue.size() >= INBOUND_QUEUE_SIZE) {
                    try {
                        this.log.fine(className, "messageArrived", "709");
                        this.spaceAvailable.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
            if (!this.quiescing) {
                this.messageQueue.addElement(sendMessage);
                object = this.workAvailable;
                synchronized (object) {
                    this.log.fine(className, "messageArrived", "710");
                    this.workAvailable.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() {
        String methodName = "quiesce";
        this.quiescing = true;
        Object object = this.spaceAvailable;
        synchronized (object) {
            this.log.fine(className, "quiesce", "711");
            this.spaceAvailable.notifyAll();
        }
    }

    public boolean isQuiesced() {
        return this.quiescing && this.completeQueue.size() == 0 && this.messageQueue.size() == 0;
    }

    private void handleMessage(MqttPublish publishMessage) throws MqttException, Exception {
        String methodName = "handleMessage";
        if (this.mqttCallback != null) {
            String destName = publishMessage.getTopicName();
            this.log.fine(className, "handleMessage", "713", new Object[]{new Integer(publishMessage.getMessageId()), destName});
            this.mqttCallback.messageArrived(destName, publishMessage.getMessage());
            if (publishMessage.getMessage().getQos() == 1) {
                this.clientComms.internalSend(new MqttPubAck(publishMessage), new MqttToken(this.clientComms.getClient().getClientId()));
            } else if (publishMessage.getMessage().getQos() == 2) {
                this.clientComms.deliveryComplete(publishMessage);
                MqttPubComp pubComp = new MqttPubComp(publishMessage);
                this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOperationComplete(MqttToken token) {
        String methodName = "asyncOperationComplete";
        if (this.running) {
            this.completeQueue.addElement(token);
            Object object = this.workAvailable;
            synchronized (object) {
                this.log.fine(className, "asyncOperationComplete", "715", new Object[]{token.internalTok.getKey()});
                this.workAvailable.notifyAll();
            }
        }
        try {
            this.handleActionComplete(token);
        }
        catch (Throwable ex) {
            this.log.fine(className, "asyncOperationComplete", "719", null, ex);
            System.err.println("problem in asyncopcomplete " + ex);
            ex.printStackTrace();
            this.clientComms.shutdownConnection(null, new MqttException(ex));
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }
}

