/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentLifeCycleListener;
import org.apache.axis2.deployment.FileSystemConfigurator;
import org.apache.axis2.deployment.URLBasedAxisConfigurator;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.SessionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationContextFactory {
    protected static final Log log = LogFactory.getLog(ConfigurationContextFactory.class);

    public static ConfigurationContext createConfigurationContext(AxisConfigurator axisConfigurator) throws AxisFault {
        AxisConfiguration axisConfig = axisConfigurator.getAxisConfiguration();
        Parameter param = axisConfig.getParameter("deploymentLifeCycleListener");
        DeploymentLifeCycleListener deploymentLifeCycleListener = null;
        if (param != null) {
            String className = (String)param.getValue();
            try {
                deploymentLifeCycleListener = (DeploymentLifeCycleListener)Class.forName(className).newInstance();
            }
            catch (InstantiationException e) {
                log.error("Can not instantiate deployment Listener " + className, e);
                throw new AxisFault("Can not instantiate deployment Listener " + className);
            }
            catch (IllegalAccessException e) {
                log.error("Illegal Access deployment Listener " + className, e);
                throw new AxisFault("Illegal Access deployment Listener " + className);
            }
            catch (ClassNotFoundException e) {
                log.error("Class not found deployment Listener " + className, e);
                throw new AxisFault("Class not found deployment Listener " + className);
            }
        }
        if (deploymentLifeCycleListener != null) {
            deploymentLifeCycleListener.preDeploy(axisConfig);
        }
        ConfigurationContext configContext = new ConfigurationContext(axisConfig);
        if (axisConfigurator instanceof DeploymentEngine) {
            ((DeploymentEngine)((Object)axisConfigurator)).setConfigContext(configContext);
        }
        ConfigurationContextFactory.setContextPaths(axisConfig, configContext);
        ConfigurationContextFactory.init(configContext);
        axisConfigurator.engageGlobalModules();
        axisConfigurator.loadServices();
        ConfigurationContextFactory.addModuleService(configContext);
        ConfigurationContextFactory.initApplicationScopeServices(configContext);
        Utils.logFaultyServiceInfo(axisConfig);
        axisConfig.setStart(true);
        if (deploymentLifeCycleListener != null) {
            deploymentLifeCycleListener.postDeploy(configContext);
        }
        if (axisConfig.getClusteringAgent() != null) {
            configContext.initCluster();
        }
        return configContext;
    }

    private static void initApplicationScopeServices(ConfigurationContext configCtx) throws AxisFault {
        Iterator<AxisServiceGroup> serviceGroups = configCtx.getAxisConfiguration().getServiceGroups();
        while (serviceGroups.hasNext()) {
            AxisServiceGroup axisServiceGroup = serviceGroups.next();
            String maxScope = SessionUtils.calculateMaxScopeForServiceGroup(axisServiceGroup);
            if (!"application".equals(maxScope)) continue;
            ServiceGroupContext serviceGroupContext = configCtx.createServiceGroupContext(axisServiceGroup);
            configCtx.addServiceGroupContextIntoApplicationScopeTable(serviceGroupContext);
            DependencyManager.initService(serviceGroupContext);
        }
    }

    private static void addModuleService(ConfigurationContext configCtx) throws AxisFault {
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        HashMap<String, AxisModule> modules = axisConfig.getModules();
        if (modules != null && modules.size() > 0) {
            for (AxisModule axisModule : modules.values()) {
                Utils.deployModuleServices(axisModule, configCtx);
            }
        }
    }

    private static void setContextPaths(AxisConfiguration axisConfig, ConfigurationContext configContext) {
        Parameter servicePath = axisConfig.getParameter("servicePath");
        if (servicePath != null) {
            String spath = ((String)servicePath.getValue()).trim();
            if (spath.length() > 0) {
                configContext.setServicePath(spath);
            }
        } else {
            configContext.setServicePath("services");
        }
        Parameter contextPath = axisConfig.getParameter("contextRoot");
        if (contextPath != null) {
            String cpath = ((String)contextPath.getValue()).trim();
            if (cpath.length() > 0) {
                configContext.setContextRoot(cpath);
            }
        } else {
            configContext.setContextRoot("axis2");
        }
    }

    public static ConfigurationContext createConfigurationContextFromFileSystem(String path, String axis2xml) throws AxisFault {
        return ConfigurationContextFactory.createConfigurationContext(new FileSystemConfigurator(path, axis2xml));
    }

    public static ConfigurationContext createConfigurationContextFromFileSystem(String path) throws AxisFault {
        return ConfigurationContextFactory.createConfigurationContextFromFileSystem(path, null);
    }

    public static ConfigurationContext createConfigurationContextFromURIs(URL axis2xml, URL repositoy) throws AxisFault {
        return ConfigurationContextFactory.createConfigurationContext(new URLBasedAxisConfigurator(axis2xml, repositoy));
    }

    private static void init(ConfigurationContext configContext) {
        ConfigurationContextFactory.initModules(configContext);
        ConfigurationContextFactory.initTransportSenders(configContext);
    }

    private static void initModules(ConfigurationContext context) {
        AxisConfiguration configuration = context.getAxisConfiguration();
        HashMap<String, AxisModule> modules = configuration.getModules();
        Collection<AxisModule> col = modules.values();
        HashMap<AxisModule, AxisFault> faultyModule = new HashMap<AxisModule, AxisFault>();
        for (AxisModule axismodule : col) {
            Module module = axismodule.getModule();
            if (module == null) continue;
            try {
                module.init(context, axismodule);
            }
            catch (AxisFault axisFault) {
                log.info(axisFault.getMessage());
                faultyModule.put(axismodule, axisFault);
            }
        }
        if (faultyModule.size() > 0) {
            for (AxisModule axisModule : faultyModule.keySet()) {
                String fileName = axisModule.getFileName() != null ? axisModule.getFileName().toString() : axisModule.getName();
                configuration.getFaultyModules().put(fileName, faultyModule.get(axisModule).toString());
                configuration.removeModule(axisModule.getName(), axisModule.getName());
            }
        }
    }

    private static void initTransportSenders(ConfigurationContext configContext) {
        AxisConfiguration axisConf = configContext.getAxisConfiguration();
        HashMap<String, TransportOutDescription> transportOuts = axisConf.getTransportsOut();
        for (TransportOutDescription transportOut : transportOuts.values()) {
            TransportSender sender = transportOut.getSender();
            if (sender == null) continue;
            try {
                sender.init(configContext, transportOut);
            }
            catch (AxisFault axisFault) {
                log.info(Messages.getMessage("transportiniterror", transportOut.getName()));
            }
        }
    }

    public static ConfigurationContext createEmptyConfigurationContext() throws AxisFault {
        AxisConfiguration axisConfiguration = new AxisConfiguration();
        ConfigurationContext configContext = new ConfigurationContext(axisConfiguration);
        if (axisConfiguration.getClusteringAgent() != null) {
            configContext.initCluster();
        }
        ConfigurationContextFactory.setContextPaths(axisConfiguration, configContext);
        return configContext;
    }

    public static ConfigurationContext createDefaultConfigurationContext() throws Exception {
        return ConfigurationContextFactory.createBasicConfigurationContext("org/apache/axis2/deployment/axis2_default.xml");
    }

    public static ConfigurationContext createBasicConfigurationContext(String resourceName) throws Exception {
        InputStream in = Loader.getResourceAsStream(resourceName);
        AxisConfiguration axisConfig = new AxisConfiguration();
        AxisConfigBuilder builder = new AxisConfigBuilder(in, axisConfig, null);
        builder.populateConfig();
        axisConfig.validateSystemPredefinedPhases();
        ConfigurationContext configContext = new ConfigurationContext(axisConfig);
        if (axisConfig.getClusteringAgent() != null) {
            configContext.initCluster();
        }
        ConfigurationContextFactory.setContextPaths(axisConfig, configContext);
        return configContext;
    }
}

